<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelSettings StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CancelSettings
 * @subpackage Structs
 */
class CancelSettings extends ApiObject
{
    /**
     * The CancelSegmentSettings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CancelSegmentSettings
     */
    public $CancelSegmentSettings;
    /**
     * The RefundRequestSettings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RefundRequestSettings
     */
    public $RefundRequestSettings;
    /**
     * The RefundSettings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RefundSettings
     */
    public $RefundSettings;
    /**
     * Constructor method for CancelSettings
     * @uses CancelSettings::setCancelSegmentSettings()
     * @uses CancelSettings::setRefundRequestSettings()
     * @uses CancelSettings::setRefundSettings()
     * @param \StructType\CancelSegmentSettings $cancelSegmentSettings
     * @param \StructType\RefundRequestSettings $refundRequestSettings
     * @param \StructType\RefundSettings $refundSettings
     */
    public function __construct(\StructType\CancelSegmentSettings $cancelSegmentSettings = null, \StructType\RefundRequestSettings $refundRequestSettings = null, \StructType\RefundSettings $refundSettings = null)
    {
        $this
            ->setCancelSegmentSettings($cancelSegmentSettings)
            ->setRefundRequestSettings($refundRequestSettings)
            ->setRefundSettings($refundSettings);
    }
    /**
     * Get CancelSegmentSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CancelSegmentSettings|null
     */
    public function getCancelSegmentSettings()
    {
        return isset($this->CancelSegmentSettings) ? $this->CancelSegmentSettings : null;
    }
    /**
     * Set CancelSegmentSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CancelSegmentSettings $cancelSegmentSettings
     * @return \StructType\CancelSettings
     */
    public function setCancelSegmentSettings(\StructType\CancelSegmentSettings $cancelSegmentSettings = null)
    {
        if (is_null($cancelSegmentSettings) || (is_array($cancelSegmentSettings) && empty($cancelSegmentSettings))) {
            unset($this->CancelSegmentSettings);
        } else {
            $this->CancelSegmentSettings = $cancelSegmentSettings;
        }
        return $this;
    }
    /**
     * Get RefundRequestSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RefundRequestSettings|null
     */
    public function getRefundRequestSettings()
    {
        return isset($this->RefundRequestSettings) ? $this->RefundRequestSettings : null;
    }
    /**
     * Set RefundRequestSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RefundRequestSettings $refundRequestSettings
     * @return \StructType\CancelSettings
     */
    public function setRefundRequestSettings(\StructType\RefundRequestSettings $refundRequestSettings = null)
    {
        if (is_null($refundRequestSettings) || (is_array($refundRequestSettings) && empty($refundRequestSettings))) {
            unset($this->RefundRequestSettings);
        } else {
            $this->RefundRequestSettings = $refundRequestSettings;
        }
        return $this;
    }
    /**
     * Get RefundSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RefundSettings|null
     */
    public function getRefundSettings()
    {
        return isset($this->RefundSettings) ? $this->RefundSettings : null;
    }
    /**
     * Set RefundSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RefundSettings $refundSettings
     * @return \StructType\CancelSettings
     */
    public function setRefundSettings(\StructType\RefundSettings $refundSettings = null)
    {
        if (is_null($refundSettings) || (is_array($refundSettings) && empty($refundSettings))) {
            unset($this->RefundSettings);
        } else {
            $this->RefundSettings = $refundSettings;
        }
        return $this;
    }
}
