<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BuyServicesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BuyServicesRequest
 * @subpackage Structs
 */
class BuyServicesRequest extends AbstractRequest
{
    /**
     * The EMDTicketFares
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEMDTicketFare
     */
    public $EMDTicketFares;
    /**
     * The PromoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromoCode;
    /**
     * The RefCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefCustomer;
    /**
     * The SaleCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleCurrencyCode;
    /**
     * Constructor method for BuyServicesRequest
     * @uses BuyServicesRequest::setEMDTicketFares()
     * @uses BuyServicesRequest::setPromoCode()
     * @uses BuyServicesRequest::setRefCustomer()
     * @uses BuyServicesRequest::setSaleCurrencyCode()
     * @param \ArrayType\ArrayOfEMDTicketFare $eMDTicketFares
     * @param string $promoCode
     * @param string $refCustomer
     * @param string $saleCurrencyCode
     */
    public function __construct(\ArrayType\ArrayOfEMDTicketFare $eMDTicketFares = null, $promoCode = null, $refCustomer = null, $saleCurrencyCode = null)
    {
        $this
            ->setEMDTicketFares($eMDTicketFares)
            ->setPromoCode($promoCode)
            ->setRefCustomer($refCustomer)
            ->setSaleCurrencyCode($saleCurrencyCode);
    }
    /**
     * Get EMDTicketFares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEMDTicketFare|null
     */
    public function getEMDTicketFares()
    {
        return isset($this->EMDTicketFares) ? $this->EMDTicketFares : null;
    }
    /**
     * Set EMDTicketFares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEMDTicketFare $eMDTicketFares
     * @return \StructType\BuyServicesRequest
     */
    public function setEMDTicketFares(\ArrayType\ArrayOfEMDTicketFare $eMDTicketFares = null)
    {
        if (is_null($eMDTicketFares) || (is_array($eMDTicketFares) && empty($eMDTicketFares))) {
            unset($this->EMDTicketFares);
        } else {
            $this->EMDTicketFares = $eMDTicketFares;
        }
        return $this;
    }
    /**
     * Get PromoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoCode()
    {
        return isset($this->PromoCode) ? $this->PromoCode : null;
    }
    /**
     * Set PromoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoCode
     * @return \StructType\BuyServicesRequest
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoCode, true), gettype($promoCode)), __LINE__);
        }
        if (is_null($promoCode) || (is_array($promoCode) && empty($promoCode))) {
            unset($this->PromoCode);
        } else {
            $this->PromoCode = $promoCode;
        }
        return $this;
    }
    /**
     * Get RefCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefCustomer()
    {
        return isset($this->RefCustomer) ? $this->RefCustomer : null;
    }
    /**
     * Set RefCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refCustomer
     * @return \StructType\BuyServicesRequest
     */
    public function setRefCustomer($refCustomer = null)
    {
        // validation for constraint: string
        if (!is_null($refCustomer) && !is_string($refCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refCustomer, true), gettype($refCustomer)), __LINE__);
        }
        if (is_null($refCustomer) || (is_array($refCustomer) && empty($refCustomer))) {
            unset($this->RefCustomer);
        } else {
            $this->RefCustomer = $refCustomer;
        }
        return $this;
    }
    /**
     * Get SaleCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleCurrencyCode()
    {
        return isset($this->SaleCurrencyCode) ? $this->SaleCurrencyCode : null;
    }
    /**
     * Set SaleCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleCurrencyCode
     * @return \StructType\BuyServicesRequest
     */
    public function setSaleCurrencyCode($saleCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleCurrencyCode) && !is_string($saleCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleCurrencyCode, true), gettype($saleCurrencyCode)), __LINE__);
        }
        if (is_null($saleCurrencyCode) || (is_array($saleCurrencyCode) && empty($saleCurrencyCode))) {
            unset($this->SaleCurrencyCode);
        } else {
            $this->SaleCurrencyCode = $saleCurrencyCode;
        }
        return $this;
    }
}
