<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BagAllowance StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BagAllowance
 * @subpackage Structs
 */
class BagAllowance extends ApiObject
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Weight;
    /**
     * The WeightMeasureQualifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WeightMeasureQualifier;
    /**
     * The CarryOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CarryOn;
    /**
     * The TotalWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalWeight;
    /**
     * Constructor method for BagAllowance
     * @uses BagAllowance::setQuantity()
     * @uses BagAllowance::setWeight()
     * @uses BagAllowance::setWeightMeasureQualifier()
     * @uses BagAllowance::setCarryOn()
     * @uses BagAllowance::setTotalWeight()
     * @param int $quantity
     * @param float $weight
     * @param string $weightMeasureQualifier
     * @param bool $carryOn
     * @param float $totalWeight
     */
    public function __construct($quantity = null, $weight = null, $weightMeasureQualifier = null, $carryOn = null, $totalWeight = null)
    {
        $this
            ->setQuantity($quantity)
            ->setWeight($weight)
            ->setWeightMeasureQualifier($weightMeasureQualifier)
            ->setCarryOn($carryOn)
            ->setTotalWeight($totalWeight);
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \StructType\BagAllowance
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get Weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \StructType\BagAllowance
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get WeightMeasureQualifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWeightMeasureQualifier()
    {
        return isset($this->WeightMeasureQualifier) ? $this->WeightMeasureQualifier : null;
    }
    /**
     * Set WeightMeasureQualifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $weightMeasureQualifier
     * @return \StructType\BagAllowance
     */
    public function setWeightMeasureQualifier($weightMeasureQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($weightMeasureQualifier) && !is_string($weightMeasureQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weightMeasureQualifier, true), gettype($weightMeasureQualifier)), __LINE__);
        }
        if (is_null($weightMeasureQualifier) || (is_array($weightMeasureQualifier) && empty($weightMeasureQualifier))) {
            unset($this->WeightMeasureQualifier);
        } else {
            $this->WeightMeasureQualifier = $weightMeasureQualifier;
        }
        return $this;
    }
    /**
     * Get CarryOn value
     * @return bool|null
     */
    public function getCarryOn()
    {
        return $this->CarryOn;
    }
    /**
     * Set CarryOn value
     * @param bool $carryOn
     * @return \StructType\BagAllowance
     */
    public function setCarryOn($carryOn = null)
    {
        // validation for constraint: boolean
        if (!is_null($carryOn) && !is_bool($carryOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($carryOn, true), gettype($carryOn)), __LINE__);
        }
        $this->CarryOn = $carryOn;
        return $this;
    }
    /**
     * Get TotalWeight value
     * @return float|null
     */
    public function getTotalWeight()
    {
        return $this->TotalWeight;
    }
    /**
     * Set TotalWeight value
     * @param float $totalWeight
     * @return \StructType\BagAllowance
     */
    public function setTotalWeight($totalWeight = null)
    {
        // validation for constraint: float
        if (!is_null($totalWeight) && !(is_float($totalWeight) || is_numeric($totalWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalWeight, true), gettype($totalWeight)), __LINE__);
        }
        $this->TotalWeight = $totalWeight;
        return $this;
    }
}
