<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticateCredentialsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AuthenticateCredentialsResponse
 * @subpackage Structs
 */
class AuthenticateCredentialsResponse extends AbstractResponse
{
    /**
     * The AuthenticateCredentialsResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticateCredentialsResponse
     */
    public $AuthenticateCredentialsResult;
    /**
     * The AuthenticationKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthenticationKey;
    /**
     * Constructor method for AuthenticateCredentialsResponse
     * @uses AuthenticateCredentialsResponse::setAuthenticateCredentialsResult()
     * @uses AuthenticateCredentialsResponse::setAuthenticationKey()
     * @param \StructType\AuthenticateCredentialsResponse $authenticateCredentialsResult
     * @param string $authenticationKey
     */
    public function __construct(\StructType\AuthenticateCredentialsResponse $authenticateCredentialsResult = null, $authenticationKey = null)
    {
        $this
            ->setAuthenticateCredentialsResult($authenticateCredentialsResult)
            ->setAuthenticationKey($authenticationKey);
    }
    /**
     * Get AuthenticateCredentialsResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticateCredentialsResponse|null
     */
    public function getAuthenticateCredentialsResult()
    {
        return isset($this->AuthenticateCredentialsResult) ? $this->AuthenticateCredentialsResult : null;
    }
    /**
     * Set AuthenticateCredentialsResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticateCredentialsResponse $authenticateCredentialsResult
     * @return \StructType\AuthenticateCredentialsResponse
     */
    public function setAuthenticateCredentialsResult(\StructType\AuthenticateCredentialsResponse $authenticateCredentialsResult = null)
    {
        if (is_null($authenticateCredentialsResult) || (is_array($authenticateCredentialsResult) && empty($authenticateCredentialsResult))) {
            unset($this->AuthenticateCredentialsResult);
        } else {
            $this->AuthenticateCredentialsResult = $authenticateCredentialsResult;
        }
        return $this;
    }
    /**
     * Get AuthenticationKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthenticationKey()
    {
        return isset($this->AuthenticationKey) ? $this->AuthenticationKey : null;
    }
    /**
     * Set AuthenticationKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authenticationKey
     * @return \StructType\AuthenticateCredentialsResponse
     */
    public function setAuthenticationKey($authenticationKey = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationKey) && !is_string($authenticationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationKey, true), gettype($authenticationKey)), __LINE__);
        }
        if (is_null($authenticationKey) || (is_array($authenticationKey) && empty($authenticationKey))) {
            unset($this->AuthenticationKey);
        } else {
            $this->AuthenticationKey = $authenticationKey;
        }
        return $this;
    }
}
