<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmountSummary StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AmountSummary
 * @subpackage Structs
 */
class AmountSummary extends AmountBase
{
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BaseAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TaxAmount;
    /**
     * Constructor method for AmountSummary
     * @uses AmountSummary::setBaseAmount()
     * @uses AmountSummary::setTaxAmount()
     * @param float $baseAmount
     * @param float $taxAmount
     */
    public function __construct($baseAmount = null, $taxAmount = null)
    {
        $this
            ->setBaseAmount($baseAmount)
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get BaseAmount value
     * @return float|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param float $baseAmount
     * @return \StructType\AmountSummary
     */
    public function setBaseAmount($baseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($baseAmount) && !(is_float($baseAmount) || is_numeric($baseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseAmount, true), gettype($baseAmount)), __LINE__);
        }
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\AmountSummary
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
}
