<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmountDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AmountDetails
 * @subpackage Structs
 */
class AmountDetails extends ApiObject
{
    /**
     * The BaseCurrencyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $BaseCurrencyAmount;
    /**
     * The FareCurrencyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FareCurrencyAmount;
    /**
     * The NUCCurrencyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $NUCCurrencyAmount;
    /**
     * Constructor method for AmountDetails
     * @uses AmountDetails::setBaseCurrencyAmount()
     * @uses AmountDetails::setFareCurrencyAmount()
     * @uses AmountDetails::setNUCCurrencyAmount()
     * @param \StructType\Amount $baseCurrencyAmount
     * @param float $fareCurrencyAmount
     * @param \StructType\Amount $nUCCurrencyAmount
     */
    public function __construct(\StructType\Amount $baseCurrencyAmount = null, $fareCurrencyAmount = null, \StructType\Amount $nUCCurrencyAmount = null)
    {
        $this
            ->setBaseCurrencyAmount($baseCurrencyAmount)
            ->setFareCurrencyAmount($fareCurrencyAmount)
            ->setNUCCurrencyAmount($nUCCurrencyAmount);
    }
    /**
     * Get BaseCurrencyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getBaseCurrencyAmount()
    {
        return isset($this->BaseCurrencyAmount) ? $this->BaseCurrencyAmount : null;
    }
    /**
     * Set BaseCurrencyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $baseCurrencyAmount
     * @return \StructType\AmountDetails
     */
    public function setBaseCurrencyAmount(\StructType\Amount $baseCurrencyAmount = null)
    {
        if (is_null($baseCurrencyAmount) || (is_array($baseCurrencyAmount) && empty($baseCurrencyAmount))) {
            unset($this->BaseCurrencyAmount);
        } else {
            $this->BaseCurrencyAmount = $baseCurrencyAmount;
        }
        return $this;
    }
    /**
     * Get FareCurrencyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFareCurrencyAmount()
    {
        return isset($this->FareCurrencyAmount) ? $this->FareCurrencyAmount : null;
    }
    /**
     * Set FareCurrencyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fareCurrencyAmount
     * @return \StructType\AmountDetails
     */
    public function setFareCurrencyAmount($fareCurrencyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($fareCurrencyAmount) && !(is_float($fareCurrencyAmount) || is_numeric($fareCurrencyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fareCurrencyAmount, true), gettype($fareCurrencyAmount)), __LINE__);
        }
        if (is_null($fareCurrencyAmount) || (is_array($fareCurrencyAmount) && empty($fareCurrencyAmount))) {
            unset($this->FareCurrencyAmount);
        } else {
            $this->FareCurrencyAmount = $fareCurrencyAmount;
        }
        return $this;
    }
    /**
     * Get NUCCurrencyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getNUCCurrencyAmount()
    {
        return isset($this->NUCCurrencyAmount) ? $this->NUCCurrencyAmount : null;
    }
    /**
     * Set NUCCurrencyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $nUCCurrencyAmount
     * @return \StructType\AmountDetails
     */
    public function setNUCCurrencyAmount(\StructType\Amount $nUCCurrencyAmount = null)
    {
        if (is_null($nUCCurrencyAmount) || (is_array($nUCCurrencyAmount) && empty($nUCCurrencyAmount))) {
            unset($this->NUCCurrencyAmount);
        } else {
            $this->NUCCurrencyAmount = $nUCCurrencyAmount;
        }
        return $this;
    }
}
