<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractTicket StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AbstractTicket
 * @subpackage Structs
 */
class AbstractTicket extends ElectronicDocument
{
    /**
     * The CreatedGMT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreatedGMT;
    /**
     * The RefIssuedByVendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefIssuedByVendor;
    /**
     * Constructor method for AbstractTicket
     * @uses AbstractTicket::setCreatedGMT()
     * @uses AbstractTicket::setRefIssuedByVendor()
     * @param string $createdGMT
     * @param string $refIssuedByVendor
     */
    public function __construct($createdGMT = null, $refIssuedByVendor = null)
    {
        $this
            ->setCreatedGMT($createdGMT)
            ->setRefIssuedByVendor($refIssuedByVendor);
    }
    /**
     * Get CreatedGMT value
     * @return string|null
     */
    public function getCreatedGMT()
    {
        return $this->CreatedGMT;
    }
    /**
     * Set CreatedGMT value
     * @param string $createdGMT
     * @return \StructType\AbstractTicket
     */
    public function setCreatedGMT($createdGMT = null)
    {
        // validation for constraint: string
        if (!is_null($createdGMT) && !is_string($createdGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdGMT, true), gettype($createdGMT)), __LINE__);
        }
        $this->CreatedGMT = $createdGMT;
        return $this;
    }
    /**
     * Get RefIssuedByVendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefIssuedByVendor()
    {
        return isset($this->RefIssuedByVendor) ? $this->RefIssuedByVendor : null;
    }
    /**
     * Set RefIssuedByVendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refIssuedByVendor
     * @return \StructType\AbstractTicket
     */
    public function setRefIssuedByVendor($refIssuedByVendor = null)
    {
        // validation for constraint: string
        if (!is_null($refIssuedByVendor) && !is_string($refIssuedByVendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refIssuedByVendor, true), gettype($refIssuedByVendor)), __LINE__);
        }
        if (is_null($refIssuedByVendor) || (is_array($refIssuedByVendor) && empty($refIssuedByVendor))) {
            unset($this->RefIssuedByVendor);
        } else {
            $this->RefIssuedByVendor = $refIssuedByVendor;
        }
        return $this;
    }
}
