<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Uncheck ServiceType
 * @subpackage Services
 */
class Uncheck extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Uncheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Uncheck $parameters
     * @return \StructType\UncheckResponse|bool
     */
    public function Uncheck(\StructType\Uncheck $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Uncheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UncheckResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
