<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Split ServiceType
 * @subpackage Services
 */
class Split extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SplitBooking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SplitBooking $parameters
     * @return \StructType\SplitBookingResponse|bool
     */
    public function SplitBooking(\StructType\SplitBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SplitBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SplitBookingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
