<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendTicketConfirmation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendTicketConfirmation $parameters
     * @return \StructType\SendTicketConfirmationResponse|bool
     */
    public function SendTicketConfirmation(\StructType\SendTicketConfirmation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendTicketConfirmation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCustomerRemovalRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendCustomerRemovalRequest $parameters
     * @return \StructType\SendCustomerRemovalRequestResponse|bool
     */
    public function SendCustomerRemovalRequest(\StructType\SendCustomerRemovalRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendCustomerRemovalRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendCustomerRemovalRequestResponse|\StructType\SendTicketConfirmationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
