<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SearchFlights
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchFlights $parameters
     * @return \StructType\SearchFlightsResponse|bool
     */
    public function SearchFlights(\StructType\SearchFlights $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchFlights($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchBooking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchBooking $parameters
     * @return \StructType\SearchBookingResponse|bool
     */
    public function SearchBooking(\StructType\SearchBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchFlightsForExchange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchFlightsForExchange $parameters
     * @return \StructType\SearchFlightsForExchangeResponse|bool
     */
    public function SearchFlightsForExchange(\StructType\SearchFlightsForExchange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchFlightsForExchange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SearchFlightsForAdditionalItinerary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchFlightsForAdditionalItinerary $parameters
     * @return \StructType\SearchFlightsForAdditionalItineraryResponse|bool
     */
    public function SearchFlightsForAdditionalItinerary(\StructType\SearchFlightsForAdditionalItinerary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchFlightsForAdditionalItinerary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchServices $parameters
     * @return \StructType\SearchServicesResponse|bool
     */
    public function SearchServices(\StructType\SearchServices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchServices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SearchBookingResponse|\StructType\SearchFlightsForAdditionalItineraryResponse|\StructType\SearchFlightsForExchangeResponse|\StructType\SearchFlightsResponse|\StructType\SearchServicesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
