<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Prepare ServiceType
 * @subpackage Services
 */
class Prepare extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PrepareFlights
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrepareFlights $parameters
     * @return \StructType\PrepareFlightsResponse|bool
     */
    public function PrepareFlights(\StructType\PrepareFlights $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareFlights($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrepareBookingModification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrepareBookingModification $parameters
     * @return \StructType\PrepareBookingModificationResponse|bool
     */
    public function PrepareBookingModification(\StructType\PrepareBookingModification $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareBookingModification($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrepareExchange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrepareExchange $parameters
     * @return \StructType\PrepareExchangeResponse|bool
     */
    public function PrepareExchange(\StructType\PrepareExchange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareExchange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrepareAdditionalItinerary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrepareAdditionalItinerary $parameters
     * @return \StructType\PrepareAdditionalItineraryResponse|bool
     */
    public function PrepareAdditionalItinerary(\StructType\PrepareAdditionalItinerary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareAdditionalItinerary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrepareCheckin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrepareCheckin $parameters
     * @return \StructType\PrepareCheckinResponse|bool
     */
    public function PrepareCheckin(\StructType\PrepareCheckin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareCheckin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrepareCancel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrepareCancel $parameters
     * @return \StructType\PrepareCancelResponse|bool
     */
    public function PrepareCancel(\StructType\PrepareCancel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PrepareAdditionalItineraryResponse|\StructType\PrepareBookingModificationResponse|\StructType\PrepareCancelResponse|\StructType\PrepareCheckinResponse|\StructType\PrepareExchangeResponse|\StructType\PrepareFlightsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
