<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Preload ServiceType
 * @subpackage Services
 */
class Preload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Preload
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Preload $parameters
     * @return \StructType\PreloadResponse|bool
     */
    public function Preload(\StructType\Preload $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Preload($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PreloadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
