<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Load ServiceType
 * @subpackage Services
 */
class Load extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LoadBooking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadBooking $parameters
     * @return \StructType\LoadBookingResponse|bool
     */
    public function LoadBooking(\StructType\LoadBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadMCOTickets
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadMCOTickets $parameters
     * @return \StructType\LoadMCOTicketsResponse|bool
     */
    public function LoadMCOTickets(\StructType\LoadMCOTickets $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadMCOTickets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadECoupons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadECoupons $parameters
     * @return \StructType\LoadECouponsResponse|bool
     */
    public function LoadECoupons(\StructType\LoadECoupons $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadECoupons($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadCustomer $parameters
     * @return \StructType\LoadCustomerResponse|bool
     */
    public function LoadCustomer(\StructType\LoadCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadFrequentFlyerAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadFrequentFlyerAccount $parameters
     * @return \StructType\LoadFrequentFlyerAccountResponse|bool
     */
    public function LoadFrequentFlyerAccount(\StructType\LoadFrequentFlyerAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadFrequentFlyerAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LoadBookingResponse|\StructType\LoadCustomerResponse|\StructType\LoadECouponsResponse|\StructType\LoadFrequentFlyerAccountResponse|\StructType\LoadMCOTicketsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
