<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetValueCodeList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetValueCodeList $parameters
     * @return \StructType\GetValueCodeListResponse|bool
     */
    public function GetValueCodeList(\StructType\GetValueCodeList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetValueCodeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetValueCodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetValueCodes $parameters
     * @return \StructType\GetValueCodesResponse|bool
     */
    public function GetValueCodes(\StructType\GetValueCodes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetValueCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetValueCodeListResponse|\StructType\GetValueCodesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
