<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Flown ServiceType
 * @subpackage Services
 */
class Flown extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FlownCoupons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FlownCoupons $parameters
     * @return \StructType\FlownCouponsResponse|bool
     */
    public function FlownCoupons(\StructType\FlownCoupons $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FlownCoupons($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FlownCouponsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
