<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customer ServiceType
 * @subpackage Services
 */
class Customer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CustomerPasswordPolicies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerPasswordPolicies $parameters
     * @return \StructType\CustomerPasswordPoliciesResponse|bool
     */
    public function CustomerPasswordPolicies(\StructType\CustomerPasswordPolicies $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerPasswordPolicies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CustomerPasswordPoliciesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
