<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Checkin ServiceType
 * @subpackage Services
 */
class Checkin extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Checkin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Checkin $parameters
     * @return \StructType\CheckinResponse|bool
     */
    public function Checkin(\StructType\Checkin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Checkin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CheckinResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
