<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authenticate ServiceType
 * @subpackage Services
 */
class Authenticate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AuthenticateCredentials
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthenticateCredentials $parameters
     * @return \StructType\AuthenticateCredentialsResponse|bool
     */
    public function AuthenticateCredentials(\StructType\AuthenticateCredentials $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AuthenticateCredentials($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AuthenticateCredentialsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
