<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfValueCode ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfValueCode
 * @subpackage Arrays
 */
class ArrayOfValueCode extends AbstractStructArrayBase
{
    /**
     * The ValueCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ValueCode[]
     */
    public $ValueCode;
    /**
     * Constructor method for ArrayOfValueCode
     * @uses ArrayOfValueCode::setValueCode()
     * @param \StructType\ValueCode[] $valueCode
     */
    public function __construct(array $valueCode = array())
    {
        $this
            ->setValueCode($valueCode);
    }
    /**
     * Get ValueCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ValueCode[]|null
     */
    public function getValueCode()
    {
        return isset($this->ValueCode) ? $this->ValueCode : null;
    }
    /**
     * This method is responsible for validating the values passed to the setValueCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValueCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueCodeForArrayConstraintsFromSetValueCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfValueCodeValueCodeItem) {
            // validation for constraint: itemType
            if (!$arrayOfValueCodeValueCodeItem instanceof \StructType\ValueCode) {
                $invalidValues[] = is_object($arrayOfValueCodeValueCodeItem) ? get_class($arrayOfValueCodeValueCodeItem) : sprintf('%s(%s)', gettype($arrayOfValueCodeValueCodeItem), var_export($arrayOfValueCodeValueCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ValueCode property can only contain items of type \StructType\ValueCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ValueCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ValueCode[] $valueCode
     * @return \ArrayType\ArrayOfValueCode
     */
    public function setValueCode(array $valueCode = array())
    {
        // validation for constraint: array
        if ('' !== ($valueCodeArrayErrorMessage = self::validateValueCodeForArrayConstraintsFromSetValueCode($valueCode))) {
            throw new \InvalidArgumentException($valueCodeArrayErrorMessage, __LINE__);
        }
        if (is_null($valueCode) || (is_array($valueCode) && empty($valueCode))) {
            unset($this->ValueCode);
        } else {
            $this->ValueCode = $valueCode;
        }
        return $this;
    }
    /**
     * Add item to ValueCode value
     * @throws \InvalidArgumentException
     * @param \StructType\ValueCode $item
     * @return \ArrayType\ArrayOfValueCode
     */
    public function addToValueCode(\StructType\ValueCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ValueCode) {
            throw new \InvalidArgumentException(sprintf('The ValueCode property can only contain items of type \StructType\ValueCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ValueCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ValueCode|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ValueCode|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ValueCode|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ValueCode|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ValueCode|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ValueCode
     */
    public function getAttributeName()
    {
        return 'ValueCode';
    }
}
