<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSegmentOption ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSegmentOption
 * @subpackage Arrays
 */
class ArrayOfSegmentOption extends AbstractStructArrayBase
{
    /**
     * The SegmentOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SegmentOption[]
     */
    public $SegmentOption;
    /**
     * Constructor method for ArrayOfSegmentOption
     * @uses ArrayOfSegmentOption::setSegmentOption()
     * @param \StructType\SegmentOption[] $segmentOption
     */
    public function __construct(array $segmentOption = array())
    {
        $this
            ->setSegmentOption($segmentOption);
    }
    /**
     * Get SegmentOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SegmentOption[]|null
     */
    public function getSegmentOption()
    {
        return isset($this->SegmentOption) ? $this->SegmentOption : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSegmentOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSegmentOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSegmentOptionForArrayConstraintsFromSetSegmentOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSegmentOptionSegmentOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfSegmentOptionSegmentOptionItem instanceof \StructType\SegmentOption) {
                $invalidValues[] = is_object($arrayOfSegmentOptionSegmentOptionItem) ? get_class($arrayOfSegmentOptionSegmentOptionItem) : sprintf('%s(%s)', gettype($arrayOfSegmentOptionSegmentOptionItem), var_export($arrayOfSegmentOptionSegmentOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SegmentOption property can only contain items of type \StructType\SegmentOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SegmentOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SegmentOption[] $segmentOption
     * @return \ArrayType\ArrayOfSegmentOption
     */
    public function setSegmentOption(array $segmentOption = array())
    {
        // validation for constraint: array
        if ('' !== ($segmentOptionArrayErrorMessage = self::validateSegmentOptionForArrayConstraintsFromSetSegmentOption($segmentOption))) {
            throw new \InvalidArgumentException($segmentOptionArrayErrorMessage, __LINE__);
        }
        if (is_null($segmentOption) || (is_array($segmentOption) && empty($segmentOption))) {
            unset($this->SegmentOption);
        } else {
            $this->SegmentOption = $segmentOption;
        }
        return $this;
    }
    /**
     * Add item to SegmentOption value
     * @throws \InvalidArgumentException
     * @param \StructType\SegmentOption $item
     * @return \ArrayType\ArrayOfSegmentOption
     */
    public function addToSegmentOption(\StructType\SegmentOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SegmentOption) {
            throw new \InvalidArgumentException(sprintf('The SegmentOption property can only contain items of type \StructType\SegmentOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SegmentOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SegmentOption|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SegmentOption|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SegmentOption|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SegmentOption|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SegmentOption|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SegmentOption
     */
    public function getAttributeName()
    {
        return 'SegmentOption';
    }
}
