<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMessageIdentity ArrayType
 * @subpackage Arrays
 */
class ArrayOfMessageIdentity extends AbstractStructArrayBase
{
    /**
     * The Identity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MessageIdentity[]
     */
    public $Identity;
    /**
     * Constructor method for ArrayOfMessageIdentity
     * @uses ArrayOfMessageIdentity::setIdentity()
     * @param \StructType\MessageIdentity[] $identity
     */
    public function __construct(array $identity = array())
    {
        $this
            ->setIdentity($identity);
    }
    /**
     * Get Identity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MessageIdentity[]|null
     */
    public function getIdentity()
    {
        return isset($this->Identity) ? $this->Identity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIdentity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdentityForArrayConstraintsFromSetIdentity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMessageIdentityIdentityItem) {
            // validation for constraint: itemType
            if (!$arrayOfMessageIdentityIdentityItem instanceof \StructType\MessageIdentity) {
                $invalidValues[] = is_object($arrayOfMessageIdentityIdentityItem) ? get_class($arrayOfMessageIdentityIdentityItem) : sprintf('%s(%s)', gettype($arrayOfMessageIdentityIdentityItem), var_export($arrayOfMessageIdentityIdentityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Identity property can only contain items of type \StructType\MessageIdentity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Identity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MessageIdentity[] $identity
     * @return \ArrayType\ArrayOfMessageIdentity
     */
    public function setIdentity(array $identity = array())
    {
        // validation for constraint: array
        if ('' !== ($identityArrayErrorMessage = self::validateIdentityForArrayConstraintsFromSetIdentity($identity))) {
            throw new \InvalidArgumentException($identityArrayErrorMessage, __LINE__);
        }
        if (is_null($identity) || (is_array($identity) && empty($identity))) {
            unset($this->Identity);
        } else {
            $this->Identity = $identity;
        }
        return $this;
    }
    /**
     * Add item to Identity value
     * @throws \InvalidArgumentException
     * @param \StructType\MessageIdentity $item
     * @return \ArrayType\ArrayOfMessageIdentity
     */
    public function addToIdentity(\StructType\MessageIdentity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MessageIdentity) {
            throw new \InvalidArgumentException(sprintf('The Identity property can only contain items of type \StructType\MessageIdentity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Identity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MessageIdentity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MessageIdentity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MessageIdentity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MessageIdentity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MessageIdentity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Identity
     */
    public function getAttributeName()
    {
        return 'Identity';
    }
}
