<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFop ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfFop
 * @subpackage Arrays
 */
class ArrayOfFop extends AbstractStructArrayBase
{
    /**
     * The Fop
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Fop[]
     */
    public $Fop;
    /**
     * Constructor method for ArrayOfFop
     * @uses ArrayOfFop::setFop()
     * @param \StructType\Fop[] $fop
     */
    public function __construct(array $fop = array())
    {
        $this
            ->setFop($fop);
    }
    /**
     * Get Fop value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Fop[]|null
     */
    public function getFop()
    {
        return isset($this->Fop) ? $this->Fop : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFop method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFop method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFopForArrayConstraintsFromSetFop(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFopFopItem) {
            // validation for constraint: itemType
            if (!$arrayOfFopFopItem instanceof \StructType\Fop) {
                $invalidValues[] = is_object($arrayOfFopFopItem) ? get_class($arrayOfFopFopItem) : sprintf('%s(%s)', gettype($arrayOfFopFopItem), var_export($arrayOfFopFopItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fop property can only contain items of type \StructType\Fop, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fop value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Fop[] $fop
     * @return \ArrayType\ArrayOfFop
     */
    public function setFop(array $fop = array())
    {
        // validation for constraint: array
        if ('' !== ($fopArrayErrorMessage = self::validateFopForArrayConstraintsFromSetFop($fop))) {
            throw new \InvalidArgumentException($fopArrayErrorMessage, __LINE__);
        }
        if (is_null($fop) || (is_array($fop) && empty($fop))) {
            unset($this->Fop);
        } else {
            $this->Fop = $fop;
        }
        return $this;
    }
    /**
     * Add item to Fop value
     * @throws \InvalidArgumentException
     * @param \StructType\Fop $item
     * @return \ArrayType\ArrayOfFop
     */
    public function addToFop(\StructType\Fop $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Fop) {
            throw new \InvalidArgumentException(sprintf('The Fop property can only contain items of type \StructType\Fop, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fop[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Fop|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Fop|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Fop|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Fop|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Fop|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Fop
     */
    public function getAttributeName()
    {
        return 'Fop';
    }
}
