<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerDocument ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCustomerDocument
 * @subpackage Arrays
 */
class ArrayOfCustomerDocument extends AbstractStructArrayBase
{
    /**
     * The CustomerDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerDocument[]
     */
    public $CustomerDocument;
    /**
     * Constructor method for ArrayOfCustomerDocument
     * @uses ArrayOfCustomerDocument::setCustomerDocument()
     * @param \StructType\CustomerDocument[] $customerDocument
     */
    public function __construct(array $customerDocument = array())
    {
        $this
            ->setCustomerDocument($customerDocument);
    }
    /**
     * Get CustomerDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerDocument[]|null
     */
    public function getCustomerDocument()
    {
        return isset($this->CustomerDocument) ? $this->CustomerDocument : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerDocumentForArrayConstraintsFromSetCustomerDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerDocumentCustomerDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerDocumentCustomerDocumentItem instanceof \StructType\CustomerDocument) {
                $invalidValues[] = is_object($arrayOfCustomerDocumentCustomerDocumentItem) ? get_class($arrayOfCustomerDocumentCustomerDocumentItem) : sprintf('%s(%s)', gettype($arrayOfCustomerDocumentCustomerDocumentItem), var_export($arrayOfCustomerDocumentCustomerDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerDocument property can only contain items of type \StructType\CustomerDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerDocument[] $customerDocument
     * @return \ArrayType\ArrayOfCustomerDocument
     */
    public function setCustomerDocument(array $customerDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($customerDocumentArrayErrorMessage = self::validateCustomerDocumentForArrayConstraintsFromSetCustomerDocument($customerDocument))) {
            throw new \InvalidArgumentException($customerDocumentArrayErrorMessage, __LINE__);
        }
        if (is_null($customerDocument) || (is_array($customerDocument) && empty($customerDocument))) {
            unset($this->CustomerDocument);
        } else {
            $this->CustomerDocument = $customerDocument;
        }
        return $this;
    }
    /**
     * Add item to CustomerDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerDocument $item
     * @return \ArrayType\ArrayOfCustomerDocument
     */
    public function addToCustomerDocument(\StructType\CustomerDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerDocument) {
            throw new \InvalidArgumentException(sprintf('The CustomerDocument property can only contain items of type \StructType\CustomerDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerDocument[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerDocument
     */
    public function getAttributeName()
    {
        return 'CustomerDocument';
    }
}
