<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://soft2u.ro/wsdl.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://soft2u.ro/wsdl.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for addCard operation/method
 */
if ($add->addCard(new \StructType\AddCardDetails()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMultipleCard operation/method
 */
if ($add->addMultipleCard(new \StructType\AddMultipleCardInput()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updateCard operation/method
 */
if ($update->updateCard(new \StructType\UpdateCardDetails()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMultipleCard operation/method
 */
if ($update->updateMultipleCard(new \StructType\UpdateMultipleCardInput()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Archive ServiceType
 */
$archive = new \ServiceType\Archive($options);
/**
 * Sample call for archiveCard operation/method
 */
if ($archive->archiveCard(new \StructType\ArchiveCardDetails()) !== false) {
    print_r($archive->getResult());
} else {
    print_r($archive->getLastError());
}
/**
 * Sample call for archiveMultipleCard operation/method
 */
if ($archive->archiveMultipleCard(new \StructType\ArchiveMultipleCardInput()) !== false) {
    print_r($archive->getResult());
} else {
    print_r($archive->getLastError());
}
/**
 * Samples for Block ServiceType
 */
$block = new \ServiceType\Block($options);
/**
 * Sample call for blockCard operation/method
 */
if ($block->blockCard(new \StructType\BlockCardDetails()) !== false) {
    print_r($block->getResult());
} else {
    print_r($block->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getCard operation/method
 */
if ($get->getCard(new \StructType\GetCardRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCardsModifiedSincedate operation/method
 */
if ($get->getCardsModifiedSincedate(new \StructType\GetCardsModifiedSincedateInput()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCardDetails operation/method
 */
if ($get->getCardDetails(new \StructType\GetCardDetailsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCardsByFilter operation/method
 */
if ($get->getCardsByFilter(new \StructType\GetCardsByFilterInput()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSmartLaneDetails operation/method
 */
if ($get->getSmartLaneDetails(new \StructType\GetSmartLaneDetailsInput()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBoardCards operation/method
 */
if ($get->getBoardCards(new \StructType\GetBoardCardsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \ServiceType\Move($options);
/**
 * Sample call for moveCardToBacklog operation/method
 */
if ($move->moveCardToBacklog(new \StructType\MoveCardToBacklogDetails()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveMultipleCardToBacklog operation/method
 */
if ($move->moveMultipleCardToBacklog(new \StructType\MoveMultipleCardToBacklogInput()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveCardOnBoard operation/method
 */
if ($move->moveCardOnBoard(new \StructType\MoveCardOnBoardDetails()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveMultipleCardOnBoard operation/method
 */
if ($move->moveMultipleCardOnBoard(new \StructType\MoveMultipleCardOnBoardInput()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveCardtoReady operation/method
 */
if ($move->moveCardtoReady(new \StructType\MoveCardtoReadyDetails()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveMultipleCardToReady operation/method
 */
if ($move->moveMultipleCardToReady(new \StructType\MoveMultipleCardToReadyInput()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Samples for Unblock ServiceType
 */
$unblock = new \ServiceType\Unblock($options);
/**
 * Sample call for unblockCard operation/method
 */
if ($unblock->unblockCard(new \StructType\UnblockCardDetails()) !== false) {
    print_r($unblock->getResult());
} else {
    print_r($unblock->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteCard operation/method
 */
if ($delete->deleteCard(new \StructType\DeleteCardInput()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteMultipleCard operation/method
 */
if ($delete->deleteMultipleCard(new \StructType\DeleteMultipleCardInput()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Transfer ServiceType
 */
$transfer = new \ServiceType\Transfer($options);
/**
 * Sample call for transferCard operation/method
 */
if ($transfer->transferCard(new \StructType\TransferCardInput()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Samples for Convert ServiceType
 */
$convert = new \ServiceType\Convert($options);
/**
 * Sample call for convertCard operation/method
 */
if ($convert->convertCard(new \StructType\ConvertCardInput()) !== false) {
    print_r($convert->getResult());
} else {
    print_r($convert->getLastError());
}
