<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for moveMultipleCardToReadyInput StructType
 * @subpackage Structs
 */
class MoveMultipleCardToReadyInput extends AbstractStructBase
{
    /**
     * The card
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Card[]
     */
    public $card;
    /**
     * The userLoginId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userLoginId;
    /**
     * Constructor method for moveMultipleCardToReadyInput
     * @uses MoveMultipleCardToReadyInput::setCard()
     * @uses MoveMultipleCardToReadyInput::setUserLoginId()
     * @param \StructType\Card[] $card
     * @param string $userLoginId
     */
    public function __construct(array $card = array(), $userLoginId = null)
    {
        $this
            ->setCard($card)
            ->setUserLoginId($userLoginId);
    }
    /**
     * Get card value
     * @return \StructType\Card[]
     */
    public function getCard()
    {
        return $this->card;
    }
    /**
     * Set card value
     * @throws \InvalidArgumentException
     * @param \StructType\Card[] $card
     * @return \StructType\MoveMultipleCardToReadyInput
     */
    public function setCard(array $card = array())
    {
        foreach ($card as $moveMultipleCardToReadyInputCardItem) {
            // validation for constraint: itemType
            if (!$moveMultipleCardToReadyInputCardItem instanceof \StructType\Card) {
                throw new \InvalidArgumentException(sprintf('The card property can only contain items of \StructType\Card, "%s" given', is_object($moveMultipleCardToReadyInputCardItem) ? get_class($moveMultipleCardToReadyInputCardItem) : gettype($moveMultipleCardToReadyInputCardItem)), __LINE__);
            }
        }
        $this->card = $card;
        return $this;
    }
    /**
     * Add item to card value
     * @throws \InvalidArgumentException
     * @param \StructType\Card $item
     * @return \StructType\MoveMultipleCardToReadyInput
     */
    public function addToCard(\StructType\Card $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Card) {
            throw new \InvalidArgumentException(sprintf('The card property can only contain items of \StructType\Card, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->card[] = $item;
        return $this;
    }
    /**
     * Get userLoginId value
     * @return string|null
     */
    public function getUserLoginId()
    {
        return $this->userLoginId;
    }
    /**
     * Set userLoginId value
     * @param string $userLoginId
     * @return \StructType\MoveMultipleCardToReadyInput
     */
    public function setUserLoginId($userLoginId = null)
    {
        // validation for constraint: string
        if (!is_null($userLoginId) && !is_string($userLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLoginId)), __LINE__);
        }
        $this->userLoginId = $userLoginId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MoveMultipleCardToReadyInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
