<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSmartLaneDetailsInput StructType
 * @subpackage Structs
 */
class GetSmartLaneDetailsInput extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The userLoginId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userLoginId;
    /**
     * Constructor method for getSmartLaneDetailsInput
     * @uses GetSmartLaneDetailsInput::setProjectId()
     * @uses GetSmartLaneDetailsInput::setUserLoginId()
     * @param string $projectId
     * @param string $userLoginId
     */
    public function __construct($projectId = null, $userLoginId = null)
    {
        $this
            ->setProjectId($projectId)
            ->setUserLoginId($userLoginId);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \StructType\GetSmartLaneDetailsInput
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get userLoginId value
     * @return string|null
     */
    public function getUserLoginId()
    {
        return $this->userLoginId;
    }
    /**
     * Set userLoginId value
     * @param string $userLoginId
     * @return \StructType\GetSmartLaneDetailsInput
     */
    public function setUserLoginId($userLoginId = null)
    {
        // validation for constraint: string
        if (!is_null($userLoginId) && !is_string($userLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLoginId)), __LINE__);
        }
        $this->userLoginId = $userLoginId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSmartLaneDetailsInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
