<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fieldsType StructType
 * @subpackage Structs
 */
class FieldsType extends AbstractStructBase
{
    /**
     * The field
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FieldType[]
     */
    public $field;
    /**
     * Constructor method for fieldsType
     * @uses FieldsType::setField()
     * @param \StructType\FieldType[] $field
     */
    public function __construct(array $field = array())
    {
        $this
            ->setField($field);
    }
    /**
     * Get field value
     * @return \StructType\FieldType[]|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @throws \InvalidArgumentException
     * @param \StructType\FieldType[] $field
     * @return \StructType\FieldsType
     */
    public function setField(array $field = array())
    {
        foreach ($field as $fieldsTypeFieldItem) {
            // validation for constraint: itemType
            if (!$fieldsTypeFieldItem instanceof \StructType\FieldType) {
                throw new \InvalidArgumentException(sprintf('The field property can only contain items of \StructType\FieldType, "%s" given', is_object($fieldsTypeFieldItem) ? get_class($fieldsTypeFieldItem) : gettype($fieldsTypeFieldItem)), __LINE__);
            }
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Add item to field value
     * @throws \InvalidArgumentException
     * @param \StructType\FieldType $item
     * @return \StructType\FieldsType
     */
    public function addToField(\StructType\FieldType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FieldType) {
            throw new \InvalidArgumentException(sprintf('The field property can only contain items of \StructType\FieldType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->field[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FieldsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
