<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for blockCardDetails StructType
 * @subpackage Structs
 */
class BlockCardDetails extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The cardUniqueId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardUniqueId;
    /**
     * The userLoginId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userLoginId;
    /**
     * The blockComment
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $blockComment;
    /**
     * Constructor method for blockCardDetails
     * @uses BlockCardDetails::setProjectId()
     * @uses BlockCardDetails::setCardType()
     * @uses BlockCardDetails::setCardUniqueId()
     * @uses BlockCardDetails::setUserLoginId()
     * @uses BlockCardDetails::setBlockComment()
     * @param string $projectId
     * @param string $cardType
     * @param string $cardUniqueId
     * @param string $userLoginId
     * @param string $blockComment
     */
    public function __construct($projectId = null, $cardType = null, $cardUniqueId = null, $userLoginId = null, $blockComment = null)
    {
        $this
            ->setProjectId($projectId)
            ->setCardType($cardType)
            ->setCardUniqueId($cardUniqueId)
            ->setUserLoginId($userLoginId)
            ->setBlockComment($blockComment);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \StructType\BlockCardDetails
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \StructType\BlockCardDetails
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get cardUniqueId value
     * @return string|null
     */
    public function getCardUniqueId()
    {
        return $this->cardUniqueId;
    }
    /**
     * Set cardUniqueId value
     * @param string $cardUniqueId
     * @return \StructType\BlockCardDetails
     */
    public function setCardUniqueId($cardUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($cardUniqueId) && !is_string($cardUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardUniqueId)), __LINE__);
        }
        $this->cardUniqueId = $cardUniqueId;
        return $this;
    }
    /**
     * Get userLoginId value
     * @return string|null
     */
    public function getUserLoginId()
    {
        return $this->userLoginId;
    }
    /**
     * Set userLoginId value
     * @param string $userLoginId
     * @return \StructType\BlockCardDetails
     */
    public function setUserLoginId($userLoginId = null)
    {
        // validation for constraint: string
        if (!is_null($userLoginId) && !is_string($userLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLoginId)), __LINE__);
        }
        $this->userLoginId = $userLoginId;
        return $this;
    }
    /**
     * Get blockComment value
     * @return string|null
     */
    public function getBlockComment()
    {
        return $this->blockComment;
    }
    /**
     * Set blockComment value
     * @param string $blockComment
     * @return \StructType\BlockCardDetails
     */
    public function setBlockComment($blockComment = null)
    {
        // validation for constraint: string
        if (!is_null($blockComment) && !is_string($blockComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blockComment)), __LINE__);
        }
        $this->blockComment = $blockComment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BlockCardDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
