<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCardRequest $part1
     * @return \StructType\GetCardResponse|bool
     */
    public function getCard(\StructType\GetCardRequest $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCardsModifiedSincedate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCardsModifiedSincedateInput $part1
     * @return \StructType\GetCardsModifiedSincedateResponse|bool
     */
    public function getCardsModifiedSincedate(\StructType\GetCardsModifiedSincedateInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getCardsModifiedSincedate($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCardDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCardDetailsRequest $part1
     * @return \StructType\GetCardDetailsResponse|bool
     */
    public function getCardDetails(\StructType\GetCardDetailsRequest $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getCardDetails($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCardsByFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCardsByFilterInput $part1
     * @return \StructType\GetCardsByFilterResponse|bool
     */
    public function getCardsByFilter(\StructType\GetCardsByFilterInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getCardsByFilter($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSmartLaneDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSmartLaneDetailsInput $part1
     * @return \StructType\GetSmartLaneDetailsResponse|bool
     */
    public function getSmartLaneDetails(\StructType\GetSmartLaneDetailsInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getSmartLaneDetails($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoardCards
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBoardCardsRequest $part1
     * @return \StructType\GetBoardCardsResponse|bool
     */
    public function getBoardCards(\StructType\GetBoardCardsRequest $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getBoardCards($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetBoardCardsResponse|\StructType\GetCardDetailsResponse|\StructType\GetCardResponse|\StructType\GetCardsByFilterResponse|\StructType\GetCardsModifiedSincedateResponse|\StructType\GetSmartLaneDetailsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
