<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCardsByFilterInput StructType
 * @subpackage Structs
 */
class GetCardsByFilterInput extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The userLoginId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userLoginId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The FilterType
     * @var \StructType\FilterType
     */
    public $FilterType;
    /**
     * Constructor method for getCardsByFilterInput
     * @uses GetCardsByFilterInput::setProjectId()
     * @uses GetCardsByFilterInput::setUserLoginId()
     * @uses GetCardsByFilterInput::setCardType()
     * @uses GetCardsByFilterInput::setFilterType()
     * @param string $projectId
     * @param string $userLoginId
     * @param string $cardType
     * @param \StructType\FilterType $filterType
     */
    public function __construct($projectId = null, $userLoginId = null, $cardType = null, \StructType\FilterType $filterType = null)
    {
        $this
            ->setProjectId($projectId)
            ->setUserLoginId($userLoginId)
            ->setCardType($cardType)
            ->setFilterType($filterType);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \StructType\GetCardsByFilterInput
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get userLoginId value
     * @return string|null
     */
    public function getUserLoginId()
    {
        return $this->userLoginId;
    }
    /**
     * Set userLoginId value
     * @param string $userLoginId
     * @return \StructType\GetCardsByFilterInput
     */
    public function setUserLoginId($userLoginId = null)
    {
        // validation for constraint: string
        if (!is_null($userLoginId) && !is_string($userLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLoginId)), __LINE__);
        }
        $this->userLoginId = $userLoginId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \StructType\GetCardsByFilterInput
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get FilterType value
     * @return \StructType\FilterType|null
     */
    public function getFilterType()
    {
        return $this->FilterType;
    }
    /**
     * Set FilterType value
     * @param \StructType\FilterType $filterType
     * @return \StructType\GetCardsByFilterInput
     */
    public function setFilterType(\StructType\FilterType $filterType = null)
    {
        $this->FilterType = $filterType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCardsByFilterInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
