<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for filterType StructType
 * @subpackage Structs
 */
class FilterType extends AbstractStructBase
{
    /**
     * The filterGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FilterGroupType[]
     */
    public $filterGroup;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * Constructor method for filterType
     * @uses FilterType::setFilterGroup()
     * @uses FilterType::setType()
     * @param \StructType\FilterGroupType[] $filterGroup
     * @param string $type
     */
    public function __construct(array $filterGroup = array(), $type = null)
    {
        $this
            ->setFilterGroup($filterGroup)
            ->setType($type);
    }
    /**
     * Get filterGroup value
     * @return \StructType\FilterGroupType[]|null
     */
    public function getFilterGroup()
    {
        return $this->filterGroup;
    }
    /**
     * Set filterGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterGroupType[] $filterGroup
     * @return \StructType\FilterType
     */
    public function setFilterGroup(array $filterGroup = array())
    {
        foreach ($filterGroup as $filterTypeFilterGroupItem) {
            // validation for constraint: itemType
            if (!$filterTypeFilterGroupItem instanceof \StructType\FilterGroupType) {
                throw new \InvalidArgumentException(sprintf('The filterGroup property can only contain items of \StructType\FilterGroupType, "%s" given', is_object($filterTypeFilterGroupItem) ? get_class($filterTypeFilterGroupItem) : gettype($filterTypeFilterGroupItem)), __LINE__);
            }
        }
        $this->filterGroup = $filterGroup;
        return $this;
    }
    /**
     * Add item to filterGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterGroupType $item
     * @return \StructType\FilterType
     */
    public function addToFilterGroup(\StructType\FilterGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FilterGroupType) {
            throw new \InvalidArgumentException(sprintf('The filterGroup property can only contain items of \StructType\FilterGroupType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->filterGroup[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\FilterType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FilterType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
