<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterAttributeType StructType
 * @subpackage Structs
 */
class FilterAttributeType extends AbstractStructBase
{
    /**
     * The field
     * @var string
     */
    public $field;
    /**
     * The criteria
     * @var string
     */
    public $criteria;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * Constructor method for FilterAttributeType
     * @uses FilterAttributeType::setField()
     * @uses FilterAttributeType::setCriteria()
     * @uses FilterAttributeType::setValue()
     * @param string $field
     * @param string $criteria
     * @param string $value
     */
    public function __construct($field = null, $criteria = null, $value = null)
    {
        $this
            ->setField($field)
            ->setCriteria($criteria)
            ->setValue($value);
    }
    /**
     * Get field value
     * @return string|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @param string $field
     * @return \StructType\FilterAttributeType
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field)), __LINE__);
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Get criteria value
     * @return string|null
     */
    public function getCriteria()
    {
        return $this->criteria;
    }
    /**
     * Set criteria value
     * @param string $criteria
     * @return \StructType\FilterAttributeType
     */
    public function setCriteria($criteria = null)
    {
        // validation for constraint: string
        if (!is_null($criteria) && !is_string($criteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($criteria)), __LINE__);
        }
        $this->criteria = $criteria;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\FilterAttributeType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FilterAttributeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
