<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for convertCardInput StructType
 * @subpackage Structs
 */
class ConvertCardInput extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var int
     */
    public $projectId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The cardUniqueId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardUniqueId;
    /**
     * The destinationCardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $destinationCardType;
    /**
     * The breakRelation
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var bool
     */
    public $breakRelation;
    /**
     * The userLoginId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userLoginId;
    /**
     * Constructor method for convertCardInput
     * @uses ConvertCardInput::setProjectId()
     * @uses ConvertCardInput::setCardType()
     * @uses ConvertCardInput::setCardUniqueId()
     * @uses ConvertCardInput::setDestinationCardType()
     * @uses ConvertCardInput::setBreakRelation()
     * @uses ConvertCardInput::setUserLoginId()
     * @param int $projectId
     * @param string $cardType
     * @param string $cardUniqueId
     * @param string $destinationCardType
     * @param bool $breakRelation
     * @param string $userLoginId
     */
    public function __construct($projectId = null, $cardType = null, $cardUniqueId = null, $destinationCardType = null, $breakRelation = null, $userLoginId = null)
    {
        $this
            ->setProjectId($projectId)
            ->setCardType($cardType)
            ->setCardUniqueId($cardUniqueId)
            ->setDestinationCardType($destinationCardType)
            ->setBreakRelation($breakRelation)
            ->setUserLoginId($userLoginId);
    }
    /**
     * Get projectId value
     * @return int|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param int $projectId
     * @return \StructType\ConvertCardInput
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: int
        if (!is_null($projectId) && !is_numeric($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \StructType\ConvertCardInput
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get cardUniqueId value
     * @return string|null
     */
    public function getCardUniqueId()
    {
        return $this->cardUniqueId;
    }
    /**
     * Set cardUniqueId value
     * @param string $cardUniqueId
     * @return \StructType\ConvertCardInput
     */
    public function setCardUniqueId($cardUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($cardUniqueId) && !is_string($cardUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardUniqueId)), __LINE__);
        }
        $this->cardUniqueId = $cardUniqueId;
        return $this;
    }
    /**
     * Get destinationCardType value
     * @return string|null
     */
    public function getDestinationCardType()
    {
        return $this->destinationCardType;
    }
    /**
     * Set destinationCardType value
     * @param string $destinationCardType
     * @return \StructType\ConvertCardInput
     */
    public function setDestinationCardType($destinationCardType = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCardType) && !is_string($destinationCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationCardType)), __LINE__);
        }
        $this->destinationCardType = $destinationCardType;
        return $this;
    }
    /**
     * Get breakRelation value
     * @return bool|null
     */
    public function getBreakRelation()
    {
        return $this->breakRelation;
    }
    /**
     * Set breakRelation value
     * @param bool $breakRelation
     * @return \StructType\ConvertCardInput
     */
    public function setBreakRelation($breakRelation = null)
    {
        // validation for constraint: boolean
        if (!is_null($breakRelation) && !is_bool($breakRelation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($breakRelation)), __LINE__);
        }
        $this->breakRelation = $breakRelation;
        return $this;
    }
    /**
     * Get userLoginId value
     * @return string|null
     */
    public function getUserLoginId()
    {
        return $this->userLoginId;
    }
    /**
     * Set userLoginId value
     * @param string $userLoginId
     * @return \StructType\ConvertCardInput
     */
    public function setUserLoginId($userLoginId = null)
    {
        // validation for constraint: string
        if (!is_null($userLoginId) && !is_string($userLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLoginId)), __LINE__);
        }
        $this->userLoginId = $userLoginId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConvertCardInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
