<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Move ServiceType
 * @subpackage Services
 */
class Move extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named moveCardToBacklog
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MoveCardToBacklogDetails $part1
     * @return \StructType\MoveCardToBacklogResponse|bool
     */
    public function moveCardToBacklog(\StructType\MoveCardToBacklogDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveCardToBacklog($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveMultipleCardToBacklog
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MoveMultipleCardToBacklogInput $part1
     * @return \StructType\MoveMultipleCardToBacklogResponse|bool
     */
    public function moveMultipleCardToBacklog(\StructType\MoveMultipleCardToBacklogInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveMultipleCardToBacklog($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveCardOnBoard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MoveCardOnBoardDetails $part1
     * @return \StructType\MoveCardOnBoardResponse|bool
     */
    public function moveCardOnBoard(\StructType\MoveCardOnBoardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveCardOnBoard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveMultipleCardOnBoard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MoveMultipleCardOnBoardInput $part1
     * @return \StructType\MoveMultipleCardOnBoardResponse|bool
     */
    public function moveMultipleCardOnBoard(\StructType\MoveMultipleCardOnBoardInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveMultipleCardOnBoard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveCardtoReady
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MoveCardtoReadyDetails $part1
     * @return \StructType\MoveCardtoReadyResponse|bool
     */
    public function moveCardtoReady(\StructType\MoveCardtoReadyDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveCardtoReady($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveMultipleCardToReady
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MoveMultipleCardToReadyInput $part1
     * @return \StructType\MoveMultipleCardToReadyResponse|bool
     */
    public function moveMultipleCardToReady(\StructType\MoveMultipleCardToReadyInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveMultipleCardToReady($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MoveCardOnBoardResponse|\StructType\MoveCardToBacklogResponse|\StructType\MoveCardtoReadyResponse|\StructType\MoveMultipleCardOnBoardResponse|\StructType\MoveMultipleCardToBacklogResponse|\StructType\MoveMultipleCardToReadyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
