<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitSearchCriteriaType StructType
 * @subpackage Structs
 */
class UnitSearchCriteriaType extends AbstractStructBase
{
    /**
     * The Criterion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UnitSearchCriterionType[]
     */
    public $Criterion;
    /**
     * The AvailableOnlyIndicator
     * @var bool
     */
    public $AvailableOnlyIndicator;
    /**
     * Constructor method for UnitSearchCriteriaType
     * @uses UnitSearchCriteriaType::setCriterion()
     * @uses UnitSearchCriteriaType::setAvailableOnlyIndicator()
     * @param \StructType\UnitSearchCriterionType[] $criterion
     * @param bool $availableOnlyIndicator
     */
    public function __construct(array $criterion = array(), $availableOnlyIndicator = null)
    {
        $this
            ->setCriterion($criterion)
            ->setAvailableOnlyIndicator($availableOnlyIndicator);
    }
    /**
     * Get Criterion value
     * @return \StructType\UnitSearchCriterionType[]|null
     */
    public function getCriterion()
    {
        return $this->Criterion;
    }
    /**
     * This method is responsible for validating the values passed to the setCriterion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCriterion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCriterionForArrayConstraintsFromSetCriterion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitSearchCriteriaTypeCriterionItem) {
            // validation for constraint: itemType
            if (!$unitSearchCriteriaTypeCriterionItem instanceof \StructType\UnitSearchCriterionType) {
                $invalidValues[] = is_object($unitSearchCriteriaTypeCriterionItem) ? get_class($unitSearchCriteriaTypeCriterionItem) : sprintf('%s(%s)', gettype($unitSearchCriteriaTypeCriterionItem), var_export($unitSearchCriteriaTypeCriterionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Criterion property can only contain items of type \StructType\UnitSearchCriterionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Criterion value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitSearchCriterionType[] $criterion
     * @return \StructType\UnitSearchCriteriaType
     */
    public function setCriterion(array $criterion = array())
    {
        // validation for constraint: array
        if ('' !== ($criterionArrayErrorMessage = self::validateCriterionForArrayConstraintsFromSetCriterion($criterion))) {
            throw new \InvalidArgumentException($criterionArrayErrorMessage, __LINE__);
        }
        $this->Criterion = $criterion;
        return $this;
    }
    /**
     * Add item to Criterion value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitSearchCriterionType $item
     * @return \StructType\UnitSearchCriteriaType
     */
    public function addToCriterion(\StructType\UnitSearchCriterionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitSearchCriterionType) {
            throw new \InvalidArgumentException(sprintf('The Criterion property can only contain items of type \StructType\UnitSearchCriterionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Criterion[] = $item;
        return $this;
    }
    /**
     * Get AvailableOnlyIndicator value
     * @return bool|null
     */
    public function getAvailableOnlyIndicator()
    {
        return $this->AvailableOnlyIndicator;
    }
    /**
     * Set AvailableOnlyIndicator value
     * @param bool $availableOnlyIndicator
     * @return \StructType\UnitSearchCriteriaType
     */
    public function setAvailableOnlyIndicator($availableOnlyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableOnlyIndicator) && !is_bool($availableOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableOnlyIndicator, true), gettype($availableOnlyIndicator)), __LINE__);
        }
        $this->AvailableOnlyIndicator = $availableOnlyIndicator;
        return $this;
    }
}
