<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitDescriptiveContentType StructType
 * @subpackage Structs
 */
class UnitDescriptiveContentType extends AbstractStructBase
{
    /**
     * The UnitInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UnitInfoType
     */
    public $UnitInfo;
    /**
     * The Policies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEVRN_PoliciesTypePolicy
     */
    public $Policies;
    /**
     * The UnitReviews
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UnitReviewsType
     */
    public $UnitReviews;
    /**
     * The Promotions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PromotionsType
     */
    public $Promotions;
    /**
     * The PropertyManagerCode
     * @var string
     */
    public $PropertyManagerCode;
    /**
     * The UnitCode
     * @var string
     */
    public $UnitCode;
    /**
     * The UnitName
     * @var string
     */
    public $UnitName;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The InternalUnitCode
     * @var string
     */
    public $InternalUnitCode;
    /**
     * The UnitHeadline
     * @var string
     */
    public $UnitHeadline;
    /**
     * The PropertyURL
     * @var string
     */
    public $PropertyURL;
    /**
     * Constructor method for UnitDescriptiveContentType
     * @uses UnitDescriptiveContentType::setUnitInfo()
     * @uses UnitDescriptiveContentType::setPolicies()
     * @uses UnitDescriptiveContentType::setUnitReviews()
     * @uses UnitDescriptiveContentType::setPromotions()
     * @uses UnitDescriptiveContentType::setPropertyManagerCode()
     * @uses UnitDescriptiveContentType::setUnitCode()
     * @uses UnitDescriptiveContentType::setUnitName()
     * @uses UnitDescriptiveContentType::setInfoSource()
     * @uses UnitDescriptiveContentType::setInternalUnitCode()
     * @uses UnitDescriptiveContentType::setUnitHeadline()
     * @uses UnitDescriptiveContentType::setPropertyURL()
     * @param \StructType\UnitInfoType $unitInfo
     * @param \ArrayType\ArrayOfEVRN_PoliciesTypePolicy $policies
     * @param \StructType\UnitReviewsType $unitReviews
     * @param \StructType\PromotionsType $promotions
     * @param string $propertyManagerCode
     * @param string $unitCode
     * @param string $unitName
     * @param string $infoSource
     * @param string $internalUnitCode
     * @param string $unitHeadline
     * @param string $propertyURL
     */
    public function __construct(\StructType\UnitInfoType $unitInfo = null, \ArrayType\ArrayOfEVRN_PoliciesTypePolicy $policies = null, \StructType\UnitReviewsType $unitReviews = null, \StructType\PromotionsType $promotions = null, $propertyManagerCode = null, $unitCode = null, $unitName = null, $infoSource = null, $internalUnitCode = null, $unitHeadline = null, $propertyURL = null)
    {
        $this
            ->setUnitInfo($unitInfo)
            ->setPolicies($policies)
            ->setUnitReviews($unitReviews)
            ->setPromotions($promotions)
            ->setPropertyManagerCode($propertyManagerCode)
            ->setUnitCode($unitCode)
            ->setUnitName($unitName)
            ->setInfoSource($infoSource)
            ->setInternalUnitCode($internalUnitCode)
            ->setUnitHeadline($unitHeadline)
            ->setPropertyURL($propertyURL);
    }
    /**
     * Get UnitInfo value
     * @return \StructType\UnitInfoType|null
     */
    public function getUnitInfo()
    {
        return $this->UnitInfo;
    }
    /**
     * Set UnitInfo value
     * @param \StructType\UnitInfoType $unitInfo
     * @return \StructType\UnitDescriptiveContentType
     */
    public function setUnitInfo(\StructType\UnitInfoType $unitInfo = null)
    {
        $this->UnitInfo = $unitInfo;
        return $this;
    }
    /**
     * Get Policies value
     * @return \ArrayType\ArrayOfEVRN_PoliciesTypePolicy|null
     */
    public function getPolicies()
    {
        return $this->Policies;
    }
    /**
     * Set Policies value
     * @param \ArrayType\ArrayOfEVRN_PoliciesTypePolicy $policies
     * @return \StructType\UnitDescriptiveContentType
     */
    public function setPolicies(\ArrayType\ArrayOfEVRN_PoliciesTypePolicy $policies = null)
    {
        $this->Policies = $policies;
        return $this;
    }
    /**
     * Get UnitReviews value
     * @return \StructType\UnitReviewsType|null
     */
    public function getUnitReviews()
    {
        return $this->UnitReviews;
    }
    /**
     * Set UnitReviews value
     * @param \StructType\UnitReviewsType $unitReviews
     * @return \StructType\UnitDescriptiveContentType
     */
    public function setUnitReviews(\StructType\UnitReviewsType $unitReviews = null)
    {
        $this->UnitReviews = $unitReviews;
        return $this;
    }
    /**
     * Get Promotions value
     * @return \StructType\PromotionsType|null
     */
    public function getPromotions()
    {
        return $this->Promotions;
    }
    /**
     * Set Promotions value
     * @param \StructType\PromotionsType $promotions
     * @return \StructType\UnitDescriptiveContentType
     */
    public function setPromotions(\StructType\PromotionsType $promotions = null)
    {
        $this->Promotions = $promotions;
        return $this;
    }
    /**
     * Get PropertyManagerCode value
     * @return string|null
     */
    public function getPropertyManagerCode()
    {
        return $this->PropertyManagerCode;
    }
    /**
     * Set PropertyManagerCode value
     * @param string $propertyManagerCode
     * @return \StructType\UnitDescriptiveContentType
     */
    public function setPropertyManagerCode($propertyManagerCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyManagerCode) && !is_string($propertyManagerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyManagerCode, true), gettype($propertyManagerCode)), __LINE__);
        }
        $this->PropertyManagerCode = $propertyManagerCode;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \StructType\UnitDescriptiveContentType
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \StructType\UnitDescriptiveContentType
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitName, true), gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\UnitDescriptiveContentType
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get InternalUnitCode value
     * @return string|null
     */
    public function getInternalUnitCode()
    {
        return $this->InternalUnitCode;
    }
    /**
     * Set InternalUnitCode value
     * @param string $internalUnitCode
     * @return \StructType\UnitDescriptiveContentType
     */
    public function setInternalUnitCode($internalUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($internalUnitCode) && !is_string($internalUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalUnitCode, true), gettype($internalUnitCode)), __LINE__);
        }
        $this->InternalUnitCode = $internalUnitCode;
        return $this;
    }
    /**
     * Get UnitHeadline value
     * @return string|null
     */
    public function getUnitHeadline()
    {
        return $this->UnitHeadline;
    }
    /**
     * Set UnitHeadline value
     * @param string $unitHeadline
     * @return \StructType\UnitDescriptiveContentType
     */
    public function setUnitHeadline($unitHeadline = null)
    {
        // validation for constraint: string
        if (!is_null($unitHeadline) && !is_string($unitHeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitHeadline, true), gettype($unitHeadline)), __LINE__);
        }
        $this->UnitHeadline = $unitHeadline;
        return $this;
    }
    /**
     * Get PropertyURL value
     * @return string|null
     */
    public function getPropertyURL()
    {
        return $this->PropertyURL;
    }
    /**
     * Set PropertyURL value
     * @param string $propertyURL
     * @return \StructType\UnitDescriptiveContentType
     */
    public function setPropertyURL($propertyURL = null)
    {
        // validation for constraint: string
        if (!is_null($propertyURL) && !is_string($propertyURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyURL, true), gettype($propertyURL)), __LINE__);
        }
        $this->PropertyURL = $propertyURL;
        return $this;
    }
}
