<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceType StructType
 * @subpackage Structs
 */
class SourceType extends AbstractStructBase
{
    /**
     * The RequestorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RequestorID
     */
    public $RequestorID;
    /**
     * The BookingChannel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BookingChannelType
     */
    public $BookingChannel;
    /**
     * Constructor method for SourceType
     * @uses SourceType::setRequestorID()
     * @uses SourceType::setBookingChannel()
     * @param \StructType\RequestorID $requestorID
     * @param \StructType\BookingChannelType $bookingChannel
     */
    public function __construct(\StructType\RequestorID $requestorID = null, \StructType\BookingChannelType $bookingChannel = null)
    {
        $this
            ->setRequestorID($requestorID)
            ->setBookingChannel($bookingChannel);
    }
    /**
     * Get RequestorID value
     * @return \StructType\RequestorID|null
     */
    public function getRequestorID()
    {
        return $this->RequestorID;
    }
    /**
     * Set RequestorID value
     * @param \StructType\RequestorID $requestorID
     * @return \StructType\SourceType
     */
    public function setRequestorID(\StructType\RequestorID $requestorID = null)
    {
        $this->RequestorID = $requestorID;
        return $this;
    }
    /**
     * Get BookingChannel value
     * @return \StructType\BookingChannelType|null
     */
    public function getBookingChannel()
    {
        return $this->BookingChannel;
    }
    /**
     * Set BookingChannel value
     * @param \StructType\BookingChannelType $bookingChannel
     * @return \StructType\SourceType
     */
    public function setBookingChannel(\StructType\BookingChannelType $bookingChannel = null)
    {
        $this->BookingChannel = $bookingChannel;
        return $this;
    }
}
