<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecreationSrvcPrefType StructType
 * @subpackage Structs
 */
class RecreationSrvcPrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The RecreationSrvcType
     * @var string
     */
    public $RecreationSrvcType;
    /**
     * Constructor method for RecreationSrvcPrefType
     * @uses RecreationSrvcPrefType::set_()
     * @uses RecreationSrvcPrefType::setPreferLevel()
     * @uses RecreationSrvcPrefType::setRecreationSrvcType()
     * @param string $_
     * @param string $preferLevel
     * @param string $recreationSrvcType
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $recreationSrvcType = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setRecreationSrvcType($recreationSrvcType);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\RecreationSrvcPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\RecreationSrvcPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get RecreationSrvcType value
     * @return string|null
     */
    public function getRecreationSrvcType()
    {
        return $this->RecreationSrvcType;
    }
    /**
     * Set RecreationSrvcType value
     * @param string $recreationSrvcType
     * @return \StructType\RecreationSrvcPrefType
     */
    public function setRecreationSrvcType($recreationSrvcType = null)
    {
        // validation for constraint: string
        if (!is_null($recreationSrvcType) && !is_string($recreationSrvcType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recreationSrvcType, true), gettype($recreationSrvcType)), __LINE__);
        }
        $this->RecreationSrvcType = $recreationSrvcType;
        return $this;
    }
}
