<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateRangeType StructType
 * @subpackage Structs
 */
class RateRangeType extends AbstractStructBase
{
    /**
     * The StayRequirement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StayRequirementType
     */
    public $StayRequirement;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Release
     * @var string
     */
    public $Release;
    /**
     * The RateType
     * @var string
     */
    public $RateType;
    /**
     * The MinRate
     * @var float
     */
    public $MinRate;
    /**
     * The MaxRate
     * @var float
     */
    public $MaxRate;
    /**
     * The FixedRate
     * @var float
     */
    public $FixedRate;
    /**
     * The FullRate
     * @var float
     */
    public $FullRate;
    /**
     * The RateTimeUnit
     * @var string
     */
    public $RateTimeUnit;
    /**
     * The MinRent
     * @var float
     */
    public $MinRent;
    /**
     * The MaxRent
     * @var float
     */
    public $MaxRent;
    /**
     * The FixedRent
     * @var float
     */
    public $FixedRent;
    /**
     * The FullRent
     * @var float
     */
    public $FullRent;
    /**
     * The MinFees
     * @var float
     */
    public $MinFees;
    /**
     * The MaxFees
     * @var float
     */
    public $MaxFees;
    /**
     * The FixedFees
     * @var float
     */
    public $FixedFees;
    /**
     * The FullFees
     * @var float
     */
    public $FullFees;
    /**
     * The MinTax
     * @var float
     */
    public $MinTax;
    /**
     * The MaxTax
     * @var float
     */
    public $MaxTax;
    /**
     * The FixedTax
     * @var float
     */
    public $FixedTax;
    /**
     * The FullTax
     * @var float
     */
    public $FullTax;
    /**
     * The SeasonName
     * @var string
     */
    public $SeasonName;
    /**
     * Constructor method for RateRangeType
     * @uses RateRangeType::setStayRequirement()
     * @uses RateRangeType::setStart()
     * @uses RateRangeType::setDuration()
     * @uses RateRangeType::setEnd()
     * @uses RateRangeType::setRelease()
     * @uses RateRangeType::setRateType()
     * @uses RateRangeType::setMinRate()
     * @uses RateRangeType::setMaxRate()
     * @uses RateRangeType::setFixedRate()
     * @uses RateRangeType::setFullRate()
     * @uses RateRangeType::setRateTimeUnit()
     * @uses RateRangeType::setMinRent()
     * @uses RateRangeType::setMaxRent()
     * @uses RateRangeType::setFixedRent()
     * @uses RateRangeType::setFullRent()
     * @uses RateRangeType::setMinFees()
     * @uses RateRangeType::setMaxFees()
     * @uses RateRangeType::setFixedFees()
     * @uses RateRangeType::setFullFees()
     * @uses RateRangeType::setMinTax()
     * @uses RateRangeType::setMaxTax()
     * @uses RateRangeType::setFixedTax()
     * @uses RateRangeType::setFullTax()
     * @uses RateRangeType::setSeasonName()
     * @param \StructType\StayRequirementType $stayRequirement
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $release
     * @param string $rateType
     * @param float $minRate
     * @param float $maxRate
     * @param float $fixedRate
     * @param float $fullRate
     * @param string $rateTimeUnit
     * @param float $minRent
     * @param float $maxRent
     * @param float $fixedRent
     * @param float $fullRent
     * @param float $minFees
     * @param float $maxFees
     * @param float $fixedFees
     * @param float $fullFees
     * @param float $minTax
     * @param float $maxTax
     * @param float $fixedTax
     * @param float $fullTax
     * @param string $seasonName
     */
    public function __construct(\StructType\StayRequirementType $stayRequirement = null, $start = null, $duration = null, $end = null, $release = null, $rateType = null, $minRate = null, $maxRate = null, $fixedRate = null, $fullRate = null, $rateTimeUnit = null, $minRent = null, $maxRent = null, $fixedRent = null, $fullRent = null, $minFees = null, $maxFees = null, $fixedFees = null, $fullFees = null, $minTax = null, $maxTax = null, $fixedTax = null, $fullTax = null, $seasonName = null)
    {
        $this
            ->setStayRequirement($stayRequirement)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setRelease($release)
            ->setRateType($rateType)
            ->setMinRate($minRate)
            ->setMaxRate($maxRate)
            ->setFixedRate($fixedRate)
            ->setFullRate($fullRate)
            ->setRateTimeUnit($rateTimeUnit)
            ->setMinRent($minRent)
            ->setMaxRent($maxRent)
            ->setFixedRent($fixedRent)
            ->setFullRent($fullRent)
            ->setMinFees($minFees)
            ->setMaxFees($maxFees)
            ->setFixedFees($fixedFees)
            ->setFullFees($fullFees)
            ->setMinTax($minTax)
            ->setMaxTax($maxTax)
            ->setFixedTax($fixedTax)
            ->setFullTax($fullTax)
            ->setSeasonName($seasonName);
    }
    /**
     * Get StayRequirement value
     * @return \StructType\StayRequirementType|null
     */
    public function getStayRequirement()
    {
        return $this->StayRequirement;
    }
    /**
     * Set StayRequirement value
     * @param \StructType\StayRequirementType $stayRequirement
     * @return \StructType\RateRangeType
     */
    public function setStayRequirement(\StructType\StayRequirementType $stayRequirement = null)
    {
        $this->StayRequirement = $stayRequirement;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\RateRangeType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\RateRangeType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\RateRangeType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Release value
     * @return string|null
     */
    public function getRelease()
    {
        return $this->Release;
    }
    /**
     * Set Release value
     * @param string $release
     * @return \StructType\RateRangeType
     */
    public function setRelease($release = null)
    {
        // validation for constraint: string
        if (!is_null($release) && !is_string($release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($release, true), gettype($release)), __LINE__);
        }
        $this->Release = $release;
        return $this;
    }
    /**
     * Get RateType value
     * @return string|null
     */
    public function getRateType()
    {
        return $this->RateType;
    }
    /**
     * Set RateType value
     * @uses \EnumType\RateTypeType::valueIsValid()
     * @uses \EnumType\RateTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateType
     * @return \StructType\RateRangeType
     */
    public function setRateType($rateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RateTypeType::valueIsValid($rateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RateTypeType', is_array($rateType) ? implode(', ', $rateType) : var_export($rateType, true), implode(', ', \EnumType\RateTypeType::getValidValues())), __LINE__);
        }
        $this->RateType = $rateType;
        return $this;
    }
    /**
     * Get MinRate value
     * @return float|null
     */
    public function getMinRate()
    {
        return $this->MinRate;
    }
    /**
     * Set MinRate value
     * @param float $minRate
     * @return \StructType\RateRangeType
     */
    public function setMinRate($minRate = null)
    {
        // validation for constraint: float
        if (!is_null($minRate) && !(is_float($minRate) || is_numeric($minRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minRate, true), gettype($minRate)), __LINE__);
        }
        $this->MinRate = $minRate;
        return $this;
    }
    /**
     * Get MaxRate value
     * @return float|null
     */
    public function getMaxRate()
    {
        return $this->MaxRate;
    }
    /**
     * Set MaxRate value
     * @param float $maxRate
     * @return \StructType\RateRangeType
     */
    public function setMaxRate($maxRate = null)
    {
        // validation for constraint: float
        if (!is_null($maxRate) && !(is_float($maxRate) || is_numeric($maxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxRate, true), gettype($maxRate)), __LINE__);
        }
        $this->MaxRate = $maxRate;
        return $this;
    }
    /**
     * Get FixedRate value
     * @return float|null
     */
    public function getFixedRate()
    {
        return $this->FixedRate;
    }
    /**
     * Set FixedRate value
     * @param float $fixedRate
     * @return \StructType\RateRangeType
     */
    public function setFixedRate($fixedRate = null)
    {
        // validation for constraint: float
        if (!is_null($fixedRate) && !(is_float($fixedRate) || is_numeric($fixedRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedRate, true), gettype($fixedRate)), __LINE__);
        }
        $this->FixedRate = $fixedRate;
        return $this;
    }
    /**
     * Get FullRate value
     * @return float|null
     */
    public function getFullRate()
    {
        return $this->FullRate;
    }
    /**
     * Set FullRate value
     * @param float $fullRate
     * @return \StructType\RateRangeType
     */
    public function setFullRate($fullRate = null)
    {
        // validation for constraint: float
        if (!is_null($fullRate) && !(is_float($fullRate) || is_numeric($fullRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fullRate, true), gettype($fullRate)), __LINE__);
        }
        $this->FullRate = $fullRate;
        return $this;
    }
    /**
     * Get RateTimeUnit value
     * @return string|null
     */
    public function getRateTimeUnit()
    {
        return $this->RateTimeUnit;
    }
    /**
     * Set RateTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateTimeUnit
     * @return \StructType\RateRangeType
     */
    public function setRateTimeUnit($rateTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($rateTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($rateTimeUnit) ? implode(', ', $rateTimeUnit) : var_export($rateTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->RateTimeUnit = $rateTimeUnit;
        return $this;
    }
    /**
     * Get MinRent value
     * @return float|null
     */
    public function getMinRent()
    {
        return $this->MinRent;
    }
    /**
     * Set MinRent value
     * @param float $minRent
     * @return \StructType\RateRangeType
     */
    public function setMinRent($minRent = null)
    {
        // validation for constraint: float
        if (!is_null($minRent) && !(is_float($minRent) || is_numeric($minRent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minRent, true), gettype($minRent)), __LINE__);
        }
        $this->MinRent = $minRent;
        return $this;
    }
    /**
     * Get MaxRent value
     * @return float|null
     */
    public function getMaxRent()
    {
        return $this->MaxRent;
    }
    /**
     * Set MaxRent value
     * @param float $maxRent
     * @return \StructType\RateRangeType
     */
    public function setMaxRent($maxRent = null)
    {
        // validation for constraint: float
        if (!is_null($maxRent) && !(is_float($maxRent) || is_numeric($maxRent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxRent, true), gettype($maxRent)), __LINE__);
        }
        $this->MaxRent = $maxRent;
        return $this;
    }
    /**
     * Get FixedRent value
     * @return float|null
     */
    public function getFixedRent()
    {
        return $this->FixedRent;
    }
    /**
     * Set FixedRent value
     * @param float $fixedRent
     * @return \StructType\RateRangeType
     */
    public function setFixedRent($fixedRent = null)
    {
        // validation for constraint: float
        if (!is_null($fixedRent) && !(is_float($fixedRent) || is_numeric($fixedRent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedRent, true), gettype($fixedRent)), __LINE__);
        }
        $this->FixedRent = $fixedRent;
        return $this;
    }
    /**
     * Get FullRent value
     * @return float|null
     */
    public function getFullRent()
    {
        return $this->FullRent;
    }
    /**
     * Set FullRent value
     * @param float $fullRent
     * @return \StructType\RateRangeType
     */
    public function setFullRent($fullRent = null)
    {
        // validation for constraint: float
        if (!is_null($fullRent) && !(is_float($fullRent) || is_numeric($fullRent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fullRent, true), gettype($fullRent)), __LINE__);
        }
        $this->FullRent = $fullRent;
        return $this;
    }
    /**
     * Get MinFees value
     * @return float|null
     */
    public function getMinFees()
    {
        return $this->MinFees;
    }
    /**
     * Set MinFees value
     * @param float $minFees
     * @return \StructType\RateRangeType
     */
    public function setMinFees($minFees = null)
    {
        // validation for constraint: float
        if (!is_null($minFees) && !(is_float($minFees) || is_numeric($minFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minFees, true), gettype($minFees)), __LINE__);
        }
        $this->MinFees = $minFees;
        return $this;
    }
    /**
     * Get MaxFees value
     * @return float|null
     */
    public function getMaxFees()
    {
        return $this->MaxFees;
    }
    /**
     * Set MaxFees value
     * @param float $maxFees
     * @return \StructType\RateRangeType
     */
    public function setMaxFees($maxFees = null)
    {
        // validation for constraint: float
        if (!is_null($maxFees) && !(is_float($maxFees) || is_numeric($maxFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxFees, true), gettype($maxFees)), __LINE__);
        }
        $this->MaxFees = $maxFees;
        return $this;
    }
    /**
     * Get FixedFees value
     * @return float|null
     */
    public function getFixedFees()
    {
        return $this->FixedFees;
    }
    /**
     * Set FixedFees value
     * @param float $fixedFees
     * @return \StructType\RateRangeType
     */
    public function setFixedFees($fixedFees = null)
    {
        // validation for constraint: float
        if (!is_null($fixedFees) && !(is_float($fixedFees) || is_numeric($fixedFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedFees, true), gettype($fixedFees)), __LINE__);
        }
        $this->FixedFees = $fixedFees;
        return $this;
    }
    /**
     * Get FullFees value
     * @return float|null
     */
    public function getFullFees()
    {
        return $this->FullFees;
    }
    /**
     * Set FullFees value
     * @param float $fullFees
     * @return \StructType\RateRangeType
     */
    public function setFullFees($fullFees = null)
    {
        // validation for constraint: float
        if (!is_null($fullFees) && !(is_float($fullFees) || is_numeric($fullFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fullFees, true), gettype($fullFees)), __LINE__);
        }
        $this->FullFees = $fullFees;
        return $this;
    }
    /**
     * Get MinTax value
     * @return float|null
     */
    public function getMinTax()
    {
        return $this->MinTax;
    }
    /**
     * Set MinTax value
     * @param float $minTax
     * @return \StructType\RateRangeType
     */
    public function setMinTax($minTax = null)
    {
        // validation for constraint: float
        if (!is_null($minTax) && !(is_float($minTax) || is_numeric($minTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minTax, true), gettype($minTax)), __LINE__);
        }
        $this->MinTax = $minTax;
        return $this;
    }
    /**
     * Get MaxTax value
     * @return float|null
     */
    public function getMaxTax()
    {
        return $this->MaxTax;
    }
    /**
     * Set MaxTax value
     * @param float $maxTax
     * @return \StructType\RateRangeType
     */
    public function setMaxTax($maxTax = null)
    {
        // validation for constraint: float
        if (!is_null($maxTax) && !(is_float($maxTax) || is_numeric($maxTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxTax, true), gettype($maxTax)), __LINE__);
        }
        $this->MaxTax = $maxTax;
        return $this;
    }
    /**
     * Get FixedTax value
     * @return float|null
     */
    public function getFixedTax()
    {
        return $this->FixedTax;
    }
    /**
     * Set FixedTax value
     * @param float $fixedTax
     * @return \StructType\RateRangeType
     */
    public function setFixedTax($fixedTax = null)
    {
        // validation for constraint: float
        if (!is_null($fixedTax) && !(is_float($fixedTax) || is_numeric($fixedTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedTax, true), gettype($fixedTax)), __LINE__);
        }
        $this->FixedTax = $fixedTax;
        return $this;
    }
    /**
     * Get FullTax value
     * @return float|null
     */
    public function getFullTax()
    {
        return $this->FullTax;
    }
    /**
     * Set FullTax value
     * @param float $fullTax
     * @return \StructType\RateRangeType
     */
    public function setFullTax($fullTax = null)
    {
        // validation for constraint: float
        if (!is_null($fullTax) && !(is_float($fullTax) || is_numeric($fullTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fullTax, true), gettype($fullTax)), __LINE__);
        }
        $this->FullTax = $fullTax;
        return $this;
    }
    /**
     * Get SeasonName value
     * @return string|null
     */
    public function getSeasonName()
    {
        return $this->SeasonName;
    }
    /**
     * Set SeasonName value
     * @param string $seasonName
     * @return \StructType\RateRangeType
     */
    public function setSeasonName($seasonName = null)
    {
        // validation for constraint: string
        if (!is_null($seasonName) && !is_string($seasonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonName, true), gettype($seasonName)), __LINE__);
        }
        $this->SeasonName = $seasonName;
        return $this;
    }
}
