<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalCharge StructType
 * @subpackage Structs
 */
class AdditionalCharge extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TotalType
     */
    public $Amount;
    /**
     * The RoomAmenityCode
     * @var string
     */
    public $RoomAmenityCode;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for AdditionalCharge
     * @uses AdditionalCharge::setAmount()
     * @uses AdditionalCharge::setRoomAmenityCode()
     * @uses AdditionalCharge::setQuantity()
     * @param \StructType\TotalType $amount
     * @param string $roomAmenityCode
     * @param int $quantity
     */
    public function __construct(\StructType\TotalType $amount = null, $roomAmenityCode = null, $quantity = null)
    {
        $this
            ->setAmount($amount)
            ->setRoomAmenityCode($roomAmenityCode)
            ->setQuantity($quantity);
    }
    /**
     * Get Amount value
     * @return \StructType\TotalType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\TotalType $amount
     * @return \StructType\AdditionalCharge
     */
    public function setAmount(\StructType\TotalType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get RoomAmenityCode value
     * @return string|null
     */
    public function getRoomAmenityCode()
    {
        return $this->RoomAmenityCode;
    }
    /**
     * Set RoomAmenityCode value
     * @param string $roomAmenityCode
     * @return \StructType\AdditionalCharge
     */
    public function setRoomAmenityCode($roomAmenityCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomAmenityCode) && !is_string($roomAmenityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomAmenityCode, true), gettype($roomAmenityCode)), __LINE__);
        }
        $this->RoomAmenityCode = $roomAmenityCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\AdditionalCharge
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
}
