<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reservation ServiceType
 * @subpackage Services
 */
class Reservation extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReservationCancel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_ReservationCancelRQ $eVRN_ReservationCancelRQ
     * @return \StructType\EVRN_ReservationCancelRS|bool
     */
    public function ReservationCancel(\StructType\EVRN_ReservationCancelRQ $eVRN_ReservationCancelRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->ReservationCancel($eVRN_ReservationCancelRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReservationUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_ReservationUpdateRQ $eVRN_ReservationUpdateRQ
     * @return \StructType\EVRN_ReservationUpdateRS|bool
     */
    public function ReservationUpdate(\StructType\EVRN_ReservationUpdateRQ $eVRN_ReservationUpdateRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->ReservationUpdate($eVRN_ReservationUpdateRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EVRN_ReservationCancelRS|\StructType\EVRN_ReservationUpdateRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
