<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitInfo StructType
 * @subpackage Structs
 */
class UnitInfo extends AbstractStructBase
{
    /**
     * The SendData
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $SendData;
    /**
     * Constructor method for UnitInfo
     * @uses UnitInfo::setSendData()
     * @param bool $sendData
     */
    public function __construct($sendData = true)
    {
        $this
            ->setSendData($sendData);
    }
    /**
     * Get SendData value
     * @return bool|null
     */
    public function getSendData()
    {
        return $this->SendData;
    }
    /**
     * Set SendData value
     * @param bool $sendData
     * @return \StructType\UnitInfo
     */
    public function setSendData($sendData = true)
    {
        // validation for constraint: boolean
        if (!is_null($sendData) && !is_bool($sendData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendData, true), gettype($sendData)), __LINE__);
        }
        $this->SendData = $sendData;
        return $this;
    }
}
