<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitCount StructType
 * @subpackage Structs
 */
class UnitCount extends AbstractStructBase
{
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The Count
     * @var int
     */
    public $Count;
    /**
     * Constructor method for UnitCount
     * @uses UnitCount::setInfoSource()
     * @uses UnitCount::setCount()
     * @param string $infoSource
     * @param int $count
     */
    public function __construct($infoSource = null, $count = null)
    {
        $this
            ->setInfoSource($infoSource)
            ->setCount($count);
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\UnitCount
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\UnitCount
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
}
