<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyManagerReviewType StructType
 * @subpackage Structs
 */
class PropertyManagerReviewType extends AbstractStructBase
{
    /**
     * The AverageReviewScore
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReviewScoreType[]
     */
    public $AverageReviewScore;
    /**
     * The ReviewCount
     * @var int
     */
    public $ReviewCount;
    /**
     * Constructor method for PropertyManagerReviewType
     * @uses PropertyManagerReviewType::setAverageReviewScore()
     * @uses PropertyManagerReviewType::setReviewCount()
     * @param \StructType\ReviewScoreType[] $averageReviewScore
     * @param int $reviewCount
     */
    public function __construct(array $averageReviewScore = array(), $reviewCount = null)
    {
        $this
            ->setAverageReviewScore($averageReviewScore)
            ->setReviewCount($reviewCount);
    }
    /**
     * Get AverageReviewScore value
     * @return \StructType\ReviewScoreType[]|null
     */
    public function getAverageReviewScore()
    {
        return $this->AverageReviewScore;
    }
    /**
     * This method is responsible for validating the values passed to the setAverageReviewScore method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAverageReviewScore method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAverageReviewScoreForArrayConstraintsFromSetAverageReviewScore(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $propertyManagerReviewTypeAverageReviewScoreItem) {
            // validation for constraint: itemType
            if (!$propertyManagerReviewTypeAverageReviewScoreItem instanceof \StructType\ReviewScoreType) {
                $invalidValues[] = is_object($propertyManagerReviewTypeAverageReviewScoreItem) ? get_class($propertyManagerReviewTypeAverageReviewScoreItem) : sprintf('%s(%s)', gettype($propertyManagerReviewTypeAverageReviewScoreItem), var_export($propertyManagerReviewTypeAverageReviewScoreItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AverageReviewScore property can only contain items of type \StructType\ReviewScoreType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AverageReviewScore value
     * @throws \InvalidArgumentException
     * @param \StructType\ReviewScoreType[] $averageReviewScore
     * @return \StructType\PropertyManagerReviewType
     */
    public function setAverageReviewScore(array $averageReviewScore = array())
    {
        // validation for constraint: array
        if ('' !== ($averageReviewScoreArrayErrorMessage = self::validateAverageReviewScoreForArrayConstraintsFromSetAverageReviewScore($averageReviewScore))) {
            throw new \InvalidArgumentException($averageReviewScoreArrayErrorMessage, __LINE__);
        }
        $this->AverageReviewScore = $averageReviewScore;
        return $this;
    }
    /**
     * Add item to AverageReviewScore value
     * @throws \InvalidArgumentException
     * @param \StructType\ReviewScoreType $item
     * @return \StructType\PropertyManagerReviewType
     */
    public function addToAverageReviewScore(\StructType\ReviewScoreType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReviewScoreType) {
            throw new \InvalidArgumentException(sprintf('The AverageReviewScore property can only contain items of type \StructType\ReviewScoreType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AverageReviewScore[] = $item;
        return $this;
    }
    /**
     * Get ReviewCount value
     * @return int|null
     */
    public function getReviewCount()
    {
        return $this->ReviewCount;
    }
    /**
     * Set ReviewCount value
     * @param int $reviewCount
     * @return \StructType\PropertyManagerReviewType
     */
    public function setReviewCount($reviewCount = null)
    {
        // validation for constraint: int
        if (!is_null($reviewCount) && !(is_int($reviewCount) || ctype_digit($reviewCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reviewCount, true), gettype($reviewCount)), __LINE__);
        }
        $this->ReviewCount = $reviewCount;
        return $this;
    }
}
