<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyManagerCategory StructType
 * @subpackage Structs
 */
class PropertyManagerCategory extends AbstractStructBase
{
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * The Option
     * @var string
     */
    public $Option;
    /**
     * Constructor method for PropertyManagerCategory
     * @uses PropertyManagerCategory::setCategory()
     * @uses PropertyManagerCategory::setOption()
     * @param string $category
     * @param string $option
     */
    public function __construct($category = null, $option = null)
    {
        $this
            ->setCategory($category)
            ->setOption($option);
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\PropertyManagerCategory
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Option value
     * @return string|null
     */
    public function getOption()
    {
        return $this->Option;
    }
    /**
     * Set Option value
     * @param string $option
     * @return \StructType\PropertyManagerCategory
     */
    public function setOption($option = null)
    {
        // validation for constraint: string
        if (!is_null($option) && !is_string($option)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($option, true), gettype($option)), __LINE__);
        }
        $this->Option = $option;
        return $this;
    }
}
