<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyLocationPrefType StructType
 * @subpackage Structs
 */
class PropertyLocationPrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The PropertyLocationType
     * @var string
     */
    public $PropertyLocationType;
    /**
     * Constructor method for PropertyLocationPrefType
     * @uses PropertyLocationPrefType::set_()
     * @uses PropertyLocationPrefType::setPreferLevel()
     * @uses PropertyLocationPrefType::setPropertyLocationType()
     * @param string $_
     * @param string $preferLevel
     * @param string $propertyLocationType
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $propertyLocationType = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setPropertyLocationType($propertyLocationType);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\PropertyLocationPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\PropertyLocationPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get PropertyLocationType value
     * @return string|null
     */
    public function getPropertyLocationType()
    {
        return $this->PropertyLocationType;
    }
    /**
     * Set PropertyLocationType value
     * @param string $propertyLocationType
     * @return \StructType\PropertyLocationPrefType
     */
    public function setPropertyLocationType($propertyLocationType = null)
    {
        // validation for constraint: string
        if (!is_null($propertyLocationType) && !is_string($propertyLocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyLocationType, true), gettype($propertyLocationType)), __LINE__);
        }
        $this->PropertyLocationType = $propertyLocationType;
        return $this;
    }
}
