<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Policy StructType
 * @subpackage Structs
 */
class Policy extends AbstractStructBase
{
    /**
     * The PolicyInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PolicyInfo
     */
    public $PolicyInfo;
    /**
     * The PetsPolicies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PetsPoliciesType
     */
    public $PetsPolicies;
    /**
     * The StayRequirements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfStayRequirementType
     */
    public $StayRequirements;
    /**
     * The CommissionPolicies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CommissionPoliciesType
     */
    public $CommissionPolicies;
    /**
     * The CancelPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CancelPenaltiesType
     */
    public $CancelPolicy;
    /**
     * The RentalAgreement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfParagraphType
     */
    public $RentalAgreement;
    /**
     * The GuaranteePaymentPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment
     */
    public $GuaranteePaymentPolicy;
    /**
     * The DefaultValidBookingMinOffset
     * @var int
     */
    public $DefaultValidBookingMinOffset;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Release
     * @var string
     */
    public $Release;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The CodeDetail
     * @var string
     */
    public $CodeDetail;
    /**
     * The LastUpdated
     * @var string
     */
    public $LastUpdated;
    /**
     * The Mon
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * @var bool
     */
    public $Tue;
    /**
     * The Weds
     * @var bool
     */
    public $Weds;
    /**
     * The Thur
     * @var bool
     */
    public $Thur;
    /**
     * The Fri
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * @var bool
     */
    public $Sat;
    /**
     * The Sun
     * @var bool
     */
    public $Sun;
    /**
     * Constructor method for Policy
     * @uses Policy::setPolicyInfo()
     * @uses Policy::setPetsPolicies()
     * @uses Policy::setStayRequirements()
     * @uses Policy::setCommissionPolicies()
     * @uses Policy::setCancelPolicy()
     * @uses Policy::setRentalAgreement()
     * @uses Policy::setGuaranteePaymentPolicy()
     * @uses Policy::setDefaultValidBookingMinOffset()
     * @uses Policy::setStart()
     * @uses Policy::setDuration()
     * @uses Policy::setEnd()
     * @uses Policy::setRelease()
     * @uses Policy::setCode()
     * @uses Policy::setCodeDetail()
     * @uses Policy::setLastUpdated()
     * @uses Policy::setMon()
     * @uses Policy::setTue()
     * @uses Policy::setWeds()
     * @uses Policy::setThur()
     * @uses Policy::setFri()
     * @uses Policy::setSat()
     * @uses Policy::setSun()
     * @param \StructType\PolicyInfo $policyInfo
     * @param \StructType\PetsPoliciesType $petsPolicies
     * @param \ArrayType\ArrayOfStayRequirementType $stayRequirements
     * @param \StructType\CommissionPoliciesType $commissionPolicies
     * @param \StructType\CancelPenaltiesType $cancelPolicy
     * @param \ArrayType\ArrayOfParagraphType $rentalAgreement
     * @param \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $guaranteePaymentPolicy
     * @param int $defaultValidBookingMinOffset
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $release
     * @param string $code
     * @param string $codeDetail
     * @param string $lastUpdated
     * @param bool $mon
     * @param bool $tue
     * @param bool $weds
     * @param bool $thur
     * @param bool $fri
     * @param bool $sat
     * @param bool $sun
     */
    public function __construct(\StructType\PolicyInfo $policyInfo = null, \StructType\PetsPoliciesType $petsPolicies = null, \ArrayType\ArrayOfStayRequirementType $stayRequirements = null, \StructType\CommissionPoliciesType $commissionPolicies = null, \StructType\CancelPenaltiesType $cancelPolicy = null, \ArrayType\ArrayOfParagraphType $rentalAgreement = null, \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $guaranteePaymentPolicy = null, $defaultValidBookingMinOffset = null, $start = null, $duration = null, $end = null, $release = null, $code = null, $codeDetail = null, $lastUpdated = null, $mon = null, $tue = null, $weds = null, $thur = null, $fri = null, $sat = null, $sun = null)
    {
        $this
            ->setPolicyInfo($policyInfo)
            ->setPetsPolicies($petsPolicies)
            ->setStayRequirements($stayRequirements)
            ->setCommissionPolicies($commissionPolicies)
            ->setCancelPolicy($cancelPolicy)
            ->setRentalAgreement($rentalAgreement)
            ->setGuaranteePaymentPolicy($guaranteePaymentPolicy)
            ->setDefaultValidBookingMinOffset($defaultValidBookingMinOffset)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setRelease($release)
            ->setCode($code)
            ->setCodeDetail($codeDetail)
            ->setLastUpdated($lastUpdated)
            ->setMon($mon)
            ->setTue($tue)
            ->setWeds($weds)
            ->setThur($thur)
            ->setFri($fri)
            ->setSat($sat)
            ->setSun($sun);
    }
    /**
     * Get PolicyInfo value
     * @return \StructType\PolicyInfo|null
     */
    public function getPolicyInfo()
    {
        return $this->PolicyInfo;
    }
    /**
     * Set PolicyInfo value
     * @param \StructType\PolicyInfo $policyInfo
     * @return \StructType\Policy
     */
    public function setPolicyInfo(\StructType\PolicyInfo $policyInfo = null)
    {
        $this->PolicyInfo = $policyInfo;
        return $this;
    }
    /**
     * Get PetsPolicies value
     * @return \StructType\PetsPoliciesType|null
     */
    public function getPetsPolicies()
    {
        return $this->PetsPolicies;
    }
    /**
     * Set PetsPolicies value
     * @param \StructType\PetsPoliciesType $petsPolicies
     * @return \StructType\Policy
     */
    public function setPetsPolicies(\StructType\PetsPoliciesType $petsPolicies = null)
    {
        $this->PetsPolicies = $petsPolicies;
        return $this;
    }
    /**
     * Get StayRequirements value
     * @return \ArrayType\ArrayOfStayRequirementType|null
     */
    public function getStayRequirements()
    {
        return $this->StayRequirements;
    }
    /**
     * Set StayRequirements value
     * @param \ArrayType\ArrayOfStayRequirementType $stayRequirements
     * @return \StructType\Policy
     */
    public function setStayRequirements(\ArrayType\ArrayOfStayRequirementType $stayRequirements = null)
    {
        $this->StayRequirements = $stayRequirements;
        return $this;
    }
    /**
     * Get CommissionPolicies value
     * @return \StructType\CommissionPoliciesType|null
     */
    public function getCommissionPolicies()
    {
        return $this->CommissionPolicies;
    }
    /**
     * Set CommissionPolicies value
     * @param \StructType\CommissionPoliciesType $commissionPolicies
     * @return \StructType\Policy
     */
    public function setCommissionPolicies(\StructType\CommissionPoliciesType $commissionPolicies = null)
    {
        $this->CommissionPolicies = $commissionPolicies;
        return $this;
    }
    /**
     * Get CancelPolicy value
     * @return \StructType\CancelPenaltiesType|null
     */
    public function getCancelPolicy()
    {
        return $this->CancelPolicy;
    }
    /**
     * Set CancelPolicy value
     * @param \StructType\CancelPenaltiesType $cancelPolicy
     * @return \StructType\Policy
     */
    public function setCancelPolicy(\StructType\CancelPenaltiesType $cancelPolicy = null)
    {
        $this->CancelPolicy = $cancelPolicy;
        return $this;
    }
    /**
     * Get RentalAgreement value
     * @return \ArrayType\ArrayOfParagraphType|null
     */
    public function getRentalAgreement()
    {
        return $this->RentalAgreement;
    }
    /**
     * Set RentalAgreement value
     * @param \ArrayType\ArrayOfParagraphType $rentalAgreement
     * @return \StructType\Policy
     */
    public function setRentalAgreement(\ArrayType\ArrayOfParagraphType $rentalAgreement = null)
    {
        $this->RentalAgreement = $rentalAgreement;
        return $this;
    }
    /**
     * Get GuaranteePaymentPolicy value
     * @return \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment|null
     */
    public function getGuaranteePaymentPolicy()
    {
        return $this->GuaranteePaymentPolicy;
    }
    /**
     * Set GuaranteePaymentPolicy value
     * @param \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $guaranteePaymentPolicy
     * @return \StructType\Policy
     */
    public function setGuaranteePaymentPolicy(\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $guaranteePaymentPolicy = null)
    {
        $this->GuaranteePaymentPolicy = $guaranteePaymentPolicy;
        return $this;
    }
    /**
     * Get DefaultValidBookingMinOffset value
     * @return int|null
     */
    public function getDefaultValidBookingMinOffset()
    {
        return $this->DefaultValidBookingMinOffset;
    }
    /**
     * Set DefaultValidBookingMinOffset value
     * @param int $defaultValidBookingMinOffset
     * @return \StructType\Policy
     */
    public function setDefaultValidBookingMinOffset($defaultValidBookingMinOffset = null)
    {
        // validation for constraint: int
        if (!is_null($defaultValidBookingMinOffset) && !(is_int($defaultValidBookingMinOffset) || ctype_digit($defaultValidBookingMinOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultValidBookingMinOffset, true), gettype($defaultValidBookingMinOffset)), __LINE__);
        }
        $this->DefaultValidBookingMinOffset = $defaultValidBookingMinOffset;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\Policy
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\Policy
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\Policy
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Release value
     * @return string|null
     */
    public function getRelease()
    {
        return $this->Release;
    }
    /**
     * Set Release value
     * @param string $release
     * @return \StructType\Policy
     */
    public function setRelease($release = null)
    {
        // validation for constraint: string
        if (!is_null($release) && !is_string($release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($release, true), gettype($release)), __LINE__);
        }
        $this->Release = $release;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Policy
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeDetail value
     * @return string|null
     */
    public function getCodeDetail()
    {
        return $this->CodeDetail;
    }
    /**
     * Set CodeDetail value
     * @param string $codeDetail
     * @return \StructType\Policy
     */
    public function setCodeDetail($codeDetail = null)
    {
        // validation for constraint: string
        if (!is_null($codeDetail) && !is_string($codeDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeDetail, true), gettype($codeDetail)), __LINE__);
        }
        $this->CodeDetail = $codeDetail;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \StructType\Policy
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdated, true), gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool|null
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \StructType\Policy
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mon, true), gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool|null
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \StructType\Policy
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tue, true), gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Weds value
     * @return bool|null
     */
    public function getWeds()
    {
        return $this->Weds;
    }
    /**
     * Set Weds value
     * @param bool $weds
     * @return \StructType\Policy
     */
    public function setWeds($weds = null)
    {
        // validation for constraint: boolean
        if (!is_null($weds) && !is_bool($weds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($weds, true), gettype($weds)), __LINE__);
        }
        $this->Weds = $weds;
        return $this;
    }
    /**
     * Get Thur value
     * @return bool|null
     */
    public function getThur()
    {
        return $this->Thur;
    }
    /**
     * Set Thur value
     * @param bool $thur
     * @return \StructType\Policy
     */
    public function setThur($thur = null)
    {
        // validation for constraint: boolean
        if (!is_null($thur) && !is_bool($thur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($thur, true), gettype($thur)), __LINE__);
        }
        $this->Thur = $thur;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool|null
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \StructType\Policy
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fri, true), gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool|null
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \StructType\Policy
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sat, true), gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool|null
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \StructType\Policy
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sun, true), gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
}
