<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EVRN_ReservationCancelRS StructType
 * @subpackage Structs
 */
class EVRN_ReservationCancelRS extends EVRN_BaseRSType
{
    /**
     * The ReservationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationID;
    /**
     * The ReservationStatusTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationStatusTypes;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - choice: Errors | Success | TPA_Extensions | Warnings
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ErrorsType
     */
    public $Errors;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - choice: Errors | Success | TPA_Extensions | Warnings
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SuccessType
     */
    public $Success;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - choice: Errors | Success | TPA_Extensions | Warnings
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - choice: Errors | Success | TPA_Extensions | Warnings
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarningsType
     */
    public $Warnings;
    /**
     * Constructor method for EVRN_ReservationCancelRS
     * @uses EVRN_ReservationCancelRS::setReservationID()
     * @uses EVRN_ReservationCancelRS::setReservationStatusTypes()
     * @uses EVRN_ReservationCancelRS::setMessage()
     * @uses EVRN_ReservationCancelRS::setErrors()
     * @uses EVRN_ReservationCancelRS::setSuccess()
     * @uses EVRN_ReservationCancelRS::setTPA_Extensions()
     * @uses EVRN_ReservationCancelRS::setWarnings()
     * @param string $reservationID
     * @param string $reservationStatusTypes
     * @param string $message
     * @param \StructType\ErrorsType $errors
     * @param \StructType\SuccessType $success
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @param \StructType\WarningsType $warnings
     */
    public function __construct($reservationID = null, $reservationStatusTypes = null, $message = null, \StructType\ErrorsType $errors = null, \StructType\SuccessType $success = null, \StructType\TPA_Extensions_Type $tPA_Extensions = null, \StructType\WarningsType $warnings = null)
    {
        $this
            ->setReservationID($reservationID)
            ->setReservationStatusTypes($reservationStatusTypes)
            ->setMessage($message)
            ->setErrors($errors)
            ->setSuccess($success)
            ->setTPA_Extensions($tPA_Extensions)
            ->setWarnings($warnings);
    }
    /**
     * Get ReservationID value
     * @return string|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * Set ReservationID value
     * @param string $reservationID
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setReservationID($reservationID = null)
    {
        // validation for constraint: string
        if (!is_null($reservationID) && !is_string($reservationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationID, true), gettype($reservationID)), __LINE__);
        }
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Get ReservationStatusTypes value
     * @return string|null
     */
    public function getReservationStatusTypes()
    {
        return $this->ReservationStatusTypes;
    }
    /**
     * Set ReservationStatusTypes value
     * @param string $reservationStatusTypes
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setReservationStatusTypes($reservationStatusTypes = null)
    {
        // validation for constraint: string
        if (!is_null($reservationStatusTypes) && !is_string($reservationStatusTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationStatusTypes, true), gettype($reservationStatusTypes)), __LINE__);
        }
        $this->ReservationStatusTypes = $reservationStatusTypes;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorsForChoiceConstraintsFromSetErrors($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'TPA_Extensions',
            'Warnings',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Errors can\'t be set as the property %s is already set. Only one property must be set among these properties: Errors, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Errors value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorsType $errors
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setErrors(\StructType\ErrorsType $errors = null)
    {
        // validation for constraint: choice(Errors, Success, TPA_Extensions, Warnings)
        if ('' !== ($errorsChoiceErrorMessage = self::validateErrorsForChoiceConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsChoiceErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get Success value
     * @return \StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSuccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccess method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSuccessForChoiceConstraintsFromSetSuccess($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Errors',
            'TPA_Extensions',
            'Warnings',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Success can\'t be set as the property %s is already set. Only one property must be set among these properties: Success, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SuccessType $success
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setSuccess(\StructType\SuccessType $success = null)
    {
        // validation for constraint: choice(Errors, Success, TPA_Extensions, Warnings)
        if ('' !== ($successChoiceErrorMessage = self::validateSuccessForChoiceConstraintsFromSetSuccess($success))) {
            throw new \InvalidArgumentException($successChoiceErrorMessage, __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return isset($this->TPA_Extensions) ? $this->TPA_Extensions : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTPA_Extensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTPA_Extensions method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTPA_ExtensionsForChoiceConstraintsFromSetTPA_Extensions($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Errors',
            'Success',
            'Warnings',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TPA_Extensions can\'t be set as the property %s is already set. Only one property must be set among these properties: TPA_Extensions, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TPA_Extensions value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setTPA_Extensions(\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        // validation for constraint: choice(Errors, Success, TPA_Extensions, Warnings)
        if ('' !== ($tPA_ExtensionsChoiceErrorMessage = self::validateTPA_ExtensionsForChoiceConstraintsFromSetTPA_Extensions($tPA_Extensions))) {
            throw new \InvalidArgumentException($tPA_ExtensionsChoiceErrorMessage, __LINE__);
        }
        if (is_null($tPA_Extensions) || (is_array($tPA_Extensions) && empty($tPA_Extensions))) {
            unset($this->TPA_Extensions);
        } else {
            $this->TPA_Extensions = $tPA_Extensions;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWarningsForChoiceConstraintsFromSetWarnings($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Errors',
            'Success',
            'TPA_Extensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Warnings can\'t be set as the property %s is already set. Only one property must be set among these properties: Warnings, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Warnings value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WarningsType $warnings
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setWarnings(\StructType\WarningsType $warnings = null)
    {
        // validation for constraint: choice(Errors, Success, TPA_Extensions, Warnings)
        if ('' !== ($warningsChoiceErrorMessage = self::validateWarningsForChoiceConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsChoiceErrorMessage, __LINE__);
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
}
