<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateTimeSpanType StructType
 * @subpackage Structs
 */
class DateTimeSpanType extends AbstractStructBase
{
    /**
     * The DateWindowRange
     * Meta information extracted from the WSDL
     * - choice: DateWindowRange | EndDateWindow | StartDateWindow
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TimeInstantType
     */
    public $DateWindowRange;
    /**
     * The EndDateWindow
     * Meta information extracted from the WSDL
     * - choice: DateWindowRange | EndDateWindow | StartDateWindow
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EndDateWindow
     */
    public $EndDateWindow;
    /**
     * The StartDateWindow
     * Meta information extracted from the WSDL
     * - choice: DateWindowRange | EndDateWindow | StartDateWindow
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StartDateWindow
     */
    public $StartDateWindow;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Release
     * @var string
     */
    public $Release;
    /**
     * Constructor method for DateTimeSpanType
     * @uses DateTimeSpanType::setDateWindowRange()
     * @uses DateTimeSpanType::setEndDateWindow()
     * @uses DateTimeSpanType::setStartDateWindow()
     * @uses DateTimeSpanType::setStart()
     * @uses DateTimeSpanType::setDuration()
     * @uses DateTimeSpanType::setEnd()
     * @uses DateTimeSpanType::setRelease()
     * @param \StructType\TimeInstantType $dateWindowRange
     * @param \StructType\EndDateWindow $endDateWindow
     * @param \StructType\StartDateWindow $startDateWindow
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $release
     */
    public function __construct(\StructType\TimeInstantType $dateWindowRange = null, \StructType\EndDateWindow $endDateWindow = null, \StructType\StartDateWindow $startDateWindow = null, $start = null, $duration = null, $end = null, $release = null)
    {
        $this
            ->setDateWindowRange($dateWindowRange)
            ->setEndDateWindow($endDateWindow)
            ->setStartDateWindow($startDateWindow)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setRelease($release);
    }
    /**
     * Get DateWindowRange value
     * @return \StructType\TimeInstantType|null
     */
    public function getDateWindowRange()
    {
        return isset($this->DateWindowRange) ? $this->DateWindowRange : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDateWindowRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateWindowRange method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDateWindowRangeForChoiceConstraintsFromSetDateWindowRange($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'EndDateWindow',
            'StartDateWindow',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DateWindowRange can\'t be set as the property %s is already set. Only one property must be set among these properties: DateWindowRange, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DateWindowRange value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TimeInstantType $dateWindowRange
     * @return \StructType\DateTimeSpanType
     */
    public function setDateWindowRange(\StructType\TimeInstantType $dateWindowRange = null)
    {
        // validation for constraint: choice(DateWindowRange, EndDateWindow, StartDateWindow)
        if ('' !== ($dateWindowRangeChoiceErrorMessage = self::validateDateWindowRangeForChoiceConstraintsFromSetDateWindowRange($dateWindowRange))) {
            throw new \InvalidArgumentException($dateWindowRangeChoiceErrorMessage, __LINE__);
        }
        if (is_null($dateWindowRange) || (is_array($dateWindowRange) && empty($dateWindowRange))) {
            unset($this->DateWindowRange);
        } else {
            $this->DateWindowRange = $dateWindowRange;
        }
        return $this;
    }
    /**
     * Get EndDateWindow value
     * @return \StructType\EndDateWindow|null
     */
    public function getEndDateWindow()
    {
        return isset($this->EndDateWindow) ? $this->EndDateWindow : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEndDateWindow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndDateWindow method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEndDateWindowForChoiceConstraintsFromSetEndDateWindow($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DateWindowRange',
            'StartDateWindow',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property EndDateWindow can\'t be set as the property %s is already set. Only one property must be set among these properties: EndDateWindow, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set EndDateWindow value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EndDateWindow $endDateWindow
     * @return \StructType\DateTimeSpanType
     */
    public function setEndDateWindow(\StructType\EndDateWindow $endDateWindow = null)
    {
        // validation for constraint: choice(DateWindowRange, EndDateWindow, StartDateWindow)
        if ('' !== ($endDateWindowChoiceErrorMessage = self::validateEndDateWindowForChoiceConstraintsFromSetEndDateWindow($endDateWindow))) {
            throw new \InvalidArgumentException($endDateWindowChoiceErrorMessage, __LINE__);
        }
        if (is_null($endDateWindow) || (is_array($endDateWindow) && empty($endDateWindow))) {
            unset($this->EndDateWindow);
        } else {
            $this->EndDateWindow = $endDateWindow;
        }
        return $this;
    }
    /**
     * Get StartDateWindow value
     * @return \StructType\StartDateWindow|null
     */
    public function getStartDateWindow()
    {
        return isset($this->StartDateWindow) ? $this->StartDateWindow : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStartDateWindow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDateWindow method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStartDateWindowForChoiceConstraintsFromSetStartDateWindow($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DateWindowRange',
            'EndDateWindow',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property StartDateWindow can\'t be set as the property %s is already set. Only one property must be set among these properties: StartDateWindow, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set StartDateWindow value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StartDateWindow $startDateWindow
     * @return \StructType\DateTimeSpanType
     */
    public function setStartDateWindow(\StructType\StartDateWindow $startDateWindow = null)
    {
        // validation for constraint: choice(DateWindowRange, EndDateWindow, StartDateWindow)
        if ('' !== ($startDateWindowChoiceErrorMessage = self::validateStartDateWindowForChoiceConstraintsFromSetStartDateWindow($startDateWindow))) {
            throw new \InvalidArgumentException($startDateWindowChoiceErrorMessage, __LINE__);
        }
        if (is_null($startDateWindow) || (is_array($startDateWindow) && empty($startDateWindow))) {
            unset($this->StartDateWindow);
        } else {
            $this->StartDateWindow = $startDateWindow;
        }
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\DateTimeSpanType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\DateTimeSpanType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\DateTimeSpanType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Release value
     * @return string|null
     */
    public function getRelease()
    {
        return $this->Release;
    }
    /**
     * Set Release value
     * @param string $release
     * @return \StructType\DateTimeSpanType
     */
    public function setRelease($release = null)
    {
        // validation for constraint: string
        if (!is_null($release) && !is_string($release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($release, true), gettype($release)), __LINE__);
        }
        $this->Release = $release;
        return $this;
    }
}
